/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import net.neoforged.gradle.common.runtime.tasks.DefaultExecute;
import net.neoforged.gradle.common.util.ToolUtilities;
import net.neoforged.gradle.dsl.common.util.Constants;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public abstract class BinaryAccessTransformer
extends DefaultExecute {
    public BinaryAccessTransformer() {
        this.setDescription("Runs the access transformer on the decompiled sources.");
        this.getExecutingJar().set(ToolUtilities.resolveTool(this.getProject(), Constants.ACCESSTRANSFORMER));
        this.getRuntimeProgramArguments().convention(this.getInputFile().map(inputFile -> {
            ArrayList args = Lists.newArrayList();
            File outputFile = this.ensureFileWorkspaceReady(this.getOutput());
            args.add("--inJar");
            args.add(inputFile.getAsFile().getAbsolutePath());
            args.add("--outJar");
            args.add(outputFile.getAbsolutePath());
            this.getTransformers().forEach(f -> {
                args.add("--atFile");
                args.add(f.getAbsolutePath());
            });
            return args;
        }));
        this.getTransformers().finalizeValueOnRead();
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInputFile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract ConfigurableFileCollection getTransformers();
}

