/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.naming.tasks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.neoforged.gradle.common.runtime.tasks.DefaultExecute;
import net.neoforged.gradle.common.util.ToolUtilities;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.util.Constants;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.util.RenameConstants;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public abstract class ApplyOfficialMappingsToCompiledJar
extends DefaultExecute
implements WithOutput {
    public ApplyOfficialMappingsToCompiledJar() {
        this.getExecutingJar().set(ToolUtilities.resolveTool(this.getProject(), Constants.FART));
        this.getProgramArguments().set(this.getShouldReverseMappings().map(shouldReverse -> {
            ArrayList result = Lists.newArrayList((Iterable)RenameConstants.DEFAULT_PROGRAMM_ARGS);
            if (shouldReverse.booleanValue()) {
                result.add("--reverse");
            }
            return result;
        }));
        this.getJvmArguments().set((Iterable)Lists.newArrayList((Iterable)RenameConstants.DEFAULT_JVM_ARGS));
        this.getMappings().fileProvider(this.getMinecraftVersion().map(minecraftVersion -> ((MinecraftArtifactCache)this.getProject().getExtensions().getByType(MinecraftArtifactCache.class)).cacheVersionMappings(minecraftVersion, DistributionType.CLIENT)));
        this.getArguments().putRegularFile("input", (Provider)this.getInput());
        this.getArguments().putRegularFile("mappings", (Provider)this.getMappings());
        this.getArguments().putRegularFile("libraries", (Provider)this.getLibraries());
        this.getOutput().convention(this.getOutputDirectory().map(d -> d.file("output.jar")));
        this.getShouldReverseMappings().convention((Object)true);
    }

    @Input
    public abstract Property<String> getMinecraftVersion();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getMappings();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getInput();

    @InputFile
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getLibraries();

    @Input
    public abstract Property<Boolean> getShouldReverseMappings();
}

