/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runs.run;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import javax.inject.Inject;
import net.neoforged.gradle.common.util.SourceSetUtils;
import net.neoforged.gradle.dsl.common.runs.run.RunSourceSets;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;

public abstract class RunSourceSetsImpl
implements RunSourceSets {
    private final Project project;
    private final Provider<Multimap<String, SourceSet>> provider;
    private final Multimap<String, SourceSet> sourceSets;

    @Inject
    public RunSourceSetsImpl(Project project) {
        this.project = project;
        this.sourceSets = HashMultimap.create();
        this.provider = project.provider(() -> this.sourceSets);
    }

    public void add(SourceSet sourceSet) {
        this.sourceSets.put((Object)SourceSetUtils.getModIdentifier(sourceSet, null), (Object)sourceSet);
    }

    public void add(Iterable<? extends SourceSet> sourceSets) {
        for (SourceSet sourceSet : sourceSets) {
            this.add(sourceSet);
        }
    }

    public void add(SourceSet ... sourceSets) {
        for (SourceSet sourceSet : sourceSets) {
            this.add(sourceSet);
        }
    }

    public void local(SourceSet sourceSet) {
        this.sourceSets.put((Object)SourceSetUtils.getModIdentifier(sourceSet, this.project), (Object)sourceSet);
    }

    public void local(Iterable<? extends SourceSet> sourceSets) {
        for (SourceSet sourceSet : sourceSets) {
            this.local(sourceSet);
        }
    }

    public void local(SourceSet ... sourceSets) {
        for (SourceSet sourceSet : sourceSets) {
            this.local(sourceSet);
        }
    }

    public void add(String groupId, SourceSet sourceSet) {
        this.sourceSets.put((Object)groupId, (Object)sourceSet);
    }

    public void add(String groupId, Iterable<? extends SourceSet> sourceSets) {
        this.sourceSets.putAll((Object)groupId, sourceSets);
    }

    public void add(String groupId, SourceSet ... sourceSets) {
        for (SourceSet sourceSet : sourceSets) {
            this.add(groupId, sourceSet);
        }
    }

    public Provider<Multimap<String, SourceSet>> all() {
        return this.provider;
    }
}

