/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runs.run;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.runs.run.DependencyHandlerImpl;
import net.neoforged.gradle.common.runs.run.RunSourceSetsImpl;
import net.neoforged.gradle.dsl.common.runs.run.DependencyHandler;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.run.RunSourceSets;
import net.neoforged.gradle.dsl.common.runs.type.RunAdapter;
import net.neoforged.gradle.dsl.common.runs.type.RunType;
import net.neoforged.gradle.util.StringCapitalizationUtils;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public abstract class RunImpl
implements ConfigurableDSLElement<Run>,
Run {
    private final Project project;
    private final String name;
    private final ListProperty<RunType> runTypes;
    private final Set<TaskProvider<? extends Task>> dependencies = Sets.newHashSet();
    private final RunSourceSets modSources;
    private final RunSourceSets unitTestSources;
    private ListProperty<String> jvmArguments;
    private MapProperty<String, String> environmentVariables;
    private ListProperty<String> programArguments;
    private MapProperty<String, String> systemProperties;

    @Inject
    public RunImpl(Project project, String name) {
        this.project = project;
        this.name = name;
        this.modSources = (RunSourceSets)project.getObjects().newInstance(RunSourceSetsImpl.class, new Object[]{project});
        this.unitTestSources = (RunSourceSets)project.getObjects().newInstance(RunSourceSetsImpl.class, new Object[]{project});
        this.jvmArguments = this.project.getObjects().listProperty(String.class);
        this.environmentVariables = this.project.getObjects().mapProperty(String.class, String.class);
        this.programArguments = this.project.getObjects().listProperty(String.class);
        this.systemProperties = this.project.getObjects().mapProperty(String.class, String.class);
        this.runTypes = this.project.getObjects().listProperty(RunType.class);
        this.getIsSingleInstance().convention((Object)true);
        this.getIsClient().convention((Object)false);
        this.getIsServer().convention((Object)false);
        this.getIsDataGenerator().convention((Object)false);
        this.getIsGameTest().convention((Object)false);
        this.getIsJUnit().convention((Object)false);
        this.getShouldBuildAllProjects().convention((Object)false);
        this.getDependencies().convention((Object)((DependencyHandler)project.getObjects().newInstance(DependencyHandlerImpl.class, new Object[]{project, String.format("RunRuntimeDependencies%s", StringCapitalizationUtils.capitalize((String)name))})));
        this.getConfigureAutomatically().convention((Object)true);
        this.getConfigureFromTypeWithName().convention((Provider)this.getConfigureAutomatically());
        this.getConfigureFromDependencies().convention((Provider)this.getConfigureAutomatically());
        this.getWorkingDirectory().convention(project.getLayout().getProjectDirectory().dir("runs").dir(this.getName()));
    }

    public Project getProject() {
        return this.project;
    }

    public final String getName() {
        return this.name;
    }

    public MapProperty<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void overrideEnvironmentVariables(MapProperty<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public abstract Property<String> getMainClass();

    public abstract Property<Boolean> getShouldBuildAllProjects();

    public RunSourceSets getUnitTestSources() {
        return this.unitTestSources;
    }

    public void unitTestSource(@NotNull SourceSet sourceSet) {
        this.getUnitTestSources().add(sourceSet);
    }

    public void unitTestSources(SourceSet ... sourceSets) {
        this.getUnitTestSources().add(sourceSets);
    }

    public void unitTestSources(@NotNull Iterable<? extends SourceSet> sourceSets) {
        this.getUnitTestSources().add(sourceSets);
    }

    public RunSourceSets getModSources() {
        return this.modSources;
    }

    public void modSource(@NotNull SourceSet sourceSet) {
        this.getModSources().add(sourceSet);
    }

    public void modSources(SourceSet ... sourceSets) {
        this.getModSources().add(sourceSets);
    }

    public void modSources(@NotNull Iterable<? extends SourceSet> sourceSets) {
        this.getModSources().add(sourceSets);
    }

    public ListProperty<String> getProgramArguments() {
        return this.programArguments;
    }

    public void overrideProgramArguments(ListProperty<String> programArguments) {
        this.programArguments = programArguments;
    }

    public ListProperty<String> getJvmArguments() {
        return this.jvmArguments;
    }

    public void overrideJvmArguments(ListProperty<String> args) {
        this.jvmArguments = args;
    }

    public MapProperty<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public void overrideSystemProperties(MapProperty<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    @Internal
    public Set<TaskProvider<? extends Task>> getTaskDependencies() {
        return ImmutableSet.copyOf(this.dependencies);
    }

    public final void configure() {
        if (((Boolean)this.getConfigureFromTypeWithName().get()).booleanValue()) {
            this.configureInternally(this.getRunTypeByName(this.name));
        }
        for (RunType runType : (List)this.runTypes.get()) {
            this.configureInternally(runType);
        }
    }

    public final void configure(@NotNull String name) {
        this.getConfigureFromTypeWithName().set((Object)false);
        this.runTypes.add(this.project.provider(() -> this.getRunTypeByName(name)));
    }

    public final void configure(@NotNull RunType runType) {
        this.getConfigureFromTypeWithName().set((Object)false);
        this.runTypes.add((Object)runType);
    }

    public void configure(@NotNull Provider<RunType> typeProvider) {
        this.getConfigureFromTypeWithName().set((Object)false);
        this.runTypes.add(typeProvider);
    }

    @SafeVarargs
    public final void dependsOn(TaskProvider<? extends Task> ... tasks) {
        this.dependencies.addAll(Arrays.asList(tasks));
    }

    public void configureInternally(@NotNull RunType spec) {
        this.project.getLogger().debug("Configuring run {} with run type {}", (Object)this.name, (Object)spec.getName());
        this.getEnvironmentVariables().putAll((Provider)spec.getEnvironmentVariables());
        this.getMainClass().convention((Provider)spec.getMainClass());
        this.getProgramArguments().addAll((Provider)spec.getArguments());
        this.getJvmArguments().addAll((Provider)spec.getJvmArguments());
        this.getIsSingleInstance().convention((Provider)spec.getIsSingleInstance());
        this.getSystemProperties().putAll((Provider)spec.getSystemProperties());
        this.getIsClient().convention((Provider)spec.getIsClient());
        this.getIsServer().convention((Provider)spec.getIsServer());
        this.getIsDataGenerator().convention((Provider)spec.getIsDataGenerator());
        this.getIsGameTest().convention((Provider)spec.getIsGameTest());
        this.getIsJUnit().convention((Provider)spec.getIsJUnit());
        this.getClasspath().from(new Object[]{spec.getClasspath()});
        if (spec.getRunAdapter().isPresent()) {
            ((RunAdapter)spec.getRunAdapter().get()).adapt((Run)this);
        }
    }

    @NotNull
    public List<String> realiseJvmArguments() {
        ArrayList<String> args = new ArrayList<String>((Collection)this.getJvmArguments().get());
        for (Map.Entry entry : ((Map)this.getSystemProperties().get()).entrySet()) {
            if (entry.getValue() != null && !((String)entry.getValue()).isEmpty()) {
                args.add("-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
                continue;
            }
            args.add("-D" + (String)entry.getKey());
        }
        return args;
    }

    private RunType getRunTypeByName(String name) {
        NamedDomainObjectContainer runTypes = (NamedDomainObjectContainer)this.project.getExtensions().getByName("runTypes");
        if (runTypes.getNames().contains(name)) {
            return (RunType)runTypes.getByName(name);
        }
        throw new GradleException("Could not find run type " + name + ". Available run types: " + runTypes.getNames());
    }
}

