/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.subsystems;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import javax.inject.Inject;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.extensions.base.WithPropertyLookup;
import net.neoforged.gradle.common.extensions.subsystems.ConventionsExtension;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Conventions;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Decompiler;
import net.neoforged.gradle.dsl.common.extensions.subsystems.DecompilerLogLevel;
import net.neoforged.gradle.dsl.common.extensions.subsystems.DevLogin;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Parchment;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Recompiler;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Tools;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.provider.Provider;

public abstract class SubsystemsExtension
extends WithPropertyLookup
implements ConfigurableDSLElement<Subsystems>,
Subsystems {
    private final Conventions conventions;

    @Inject
    public SubsystemsExtension(Project project) {
        super(project);
        this.conventions = (Conventions)project.getObjects().newInstance(ConventionsExtension.class, new Object[]{project});
        this.configureDecompilerDefaults();
        this.configureRecompilerDefaults();
        this.configureParchmentDefaults();
        this.configureToolsDefaults();
        this.configureDevLoginDefaults();
    }

    private void configureDevLoginDefaults() {
        DevLogin devLogin = this.getDevLogin();
        devLogin.getEnabled().convention(this.getBooleanProperty("devLogin.enabled").orElse((Object)true));
        devLogin.getMainClass().convention(this.getStringProperty("devLogin.mainClass").orElse((Object)"net.covers1624.devlogin.DevLogin"));
        devLogin.getConfigurationSuffix().convention(this.getStringProperty("devLogin.configurationSuffix").orElse((Object)"DevLoginLocalOnly"));
        devLogin.getConventionForRun().convention(this.getBooleanProperty("devLogin.conventionForRun").orElse((Object)false));
    }

    private void configureToolsDefaults() {
        Tools tools = this.getTools();
        tools.getJST().convention(this.getStringProperty("tools.jst").orElse((Object)"net.neoforged.jst:jst-cli-bundle:1.0.38"));
        tools.getDevLogin().convention(this.getStringProperty("tools.devLogin").orElse((Object)"net.covers1624:DevLogin:0.1.0.4"));
    }

    private void configureDecompilerDefaults() {
        Decompiler decompiler = this.getDecompiler();
        decompiler.getMaxMemory().convention(this.getStringProperty("decompiler.maxMemory"));
        decompiler.getMaxThreads().convention(this.getStringProperty("decompiler.maxThreads").map(Integer::parseUnsignedInt));
        decompiler.getLogLevel().convention(this.getStringProperty("decompiler.logLevel").map(s -> {
            try {
                return DecompilerLogLevel.valueOf((String)s.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                throw new GradleException("Unknown DecompilerLogLevel: " + s + ". Available options: " + Arrays.toString(DecompilerLogLevel.values()));
            }
        }));
        decompiler.getJvmArgs().convention(this.getSpaceSeparatedListProperty("decompiler.jvmArgs").orElse(Collections.emptyList()));
    }

    private void configureRecompilerDefaults() {
        Recompiler recompiler = this.getRecompiler();
        recompiler.getArgs().convention(this.getSpaceSeparatedListProperty("recompiler.args").orElse(Collections.emptyList()));
        recompiler.getJvmArgs().convention(this.getSpaceSeparatedListProperty("recompiler.jvmArgs").orElse(Collections.emptyList()));
        recompiler.getMaxMemory().convention(this.getStringProperty("recompiler.maxMemory").orElse((Object)"1g"));
        recompiler.getShouldFork().convention(this.getBooleanProperty("recompiler.shouldFork").orElse((Object)true));
    }

    private void configureParchmentDefaults() {
        Parchment parchment = this.getParchment();
        parchment.getParchmentArtifact().convention(this.getStringProperty("parchment.parchmentArtifact").orElse(parchment.getMinecraftVersion().zip((Provider)parchment.getMappingsVersion(), (minecraftVersion, mappingVersion) -> "org.parchmentmc.data:parchment-" + minecraftVersion + ":" + mappingVersion + ":checked@zip")));
        parchment.getMinecraftVersion().convention(this.getStringProperty("parchment.minecraftVersion"));
        parchment.getMappingsVersion().convention(this.getStringProperty("parchment.mappingsVersion"));
        parchment.getAddRepository().convention(this.getBooleanProperty("parchment.addRepository").orElse((Object)true));
        parchment.getEnabled().convention(parchment.getParchmentArtifact().map(s -> !s.isEmpty()).orElse(this.getBooleanProperty("parchment.enabled").orElse((Object)false)));
        this.project.afterEvaluate(p -> {
            if (!((Boolean)parchment.getEnabled().get()).booleanValue() || !((Boolean)parchment.getAddRepository().get()).booleanValue()) {
                return;
            }
            MavenArtifactRepository repo = p.getRepositories().maven(m -> {
                m.setName("Parchment Data");
                m.setUrl(URI.create("https://maven.parchmentmc.org/"));
                m.mavenContent(mavenContent -> mavenContent.includeGroup("org.parchmentmc.data"));
            });
            p.getRepositories().remove((Object)repo);
            p.getRepositories().addFirst((ArtifactRepository)repo);
        });
    }

    public Conventions getConventions() {
        return this.conventions;
    }
}

