/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.dependency.replacement;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.extensions.IdeManagementExtension;
import net.neoforged.gradle.common.extensions.dependency.replacement.Context;
import net.neoforged.gradle.common.extensions.dependency.replacement.Handler;
import net.neoforged.gradle.common.extensions.dependency.replacement.RepoEntryDefinition;
import net.neoforged.gradle.common.tasks.ArtifactFromOutput;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacementHandler;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacer;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.ReplacementAware;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.ReplacementResult;
import net.neoforged.gradle.dsl.common.extensions.repository.Entry;
import net.neoforged.gradle.dsl.common.extensions.repository.EntryDefinition;
import net.neoforged.gradle.dsl.common.extensions.repository.Repository;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.dsl.common.util.ConfigurationUtils;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class ReplacementLogic
implements ConfigurableDSLElement<DependencyReplacement>,
DependencyReplacement {
    private final Project project;
    private final Table<Dependency, Configuration, Optional<ReplacementResult>> dependencyReplacementInformation = HashBasedTable.create();
    private final Table<Dependency, Configuration, Dependency> originalDependencyLookup = HashBasedTable.create();
    private final NamedDomainObjectContainer<DependencyReplacementHandler> dependencyReplacementHandlers;

    @Inject
    public ReplacementLogic(Project project) {
        this.project = project;
        this.project.getConfigurations().configureEach(this::handleConfiguration);
        this.dependencyReplacementHandlers = this.project.getObjects().domainObjectContainer(DependencyReplacementHandler.class, name -> (DependencyReplacementHandler)this.project.getObjects().newInstance(Handler.class, new Object[]{this.project, name}));
    }

    public void handleConfiguration(Configuration configuration) {
        configuration.getDependencies().whenObjectAdded(dependency -> {
            if (ConfigurationUtils.isUnhandledConfiguration((Configuration)configuration)) {
                return;
            }
            if (dependency instanceof ModuleDependency) {
                ModuleDependency moduleDependency = (ModuleDependency)dependency;
                this.handleDependency(configuration, moduleDependency);
            }
        });
    }

    public Project getProject() {
        return this.project;
    }

    @NotNull
    public NamedDomainObjectContainer<DependencyReplacementHandler> getReplacementHandlers() {
        return this.dependencyReplacementHandlers;
    }

    @NotNull
    public Dependency optionallyConvertBackToOriginal(Dependency dependency, Configuration configuration) {
        Dependency originalDependency = (Dependency)this.originalDependencyLookup.get((Object)dependency, (Object)configuration);
        return originalDependency == null ? dependency : originalDependency;
    }

    @VisibleForTesting
    void handleDependency(Configuration configuration, ModuleDependency dependency) {
        Optional candidate;
        Repository repository = (Repository)this.project.getExtensions().getByType(Repository.class);
        if (repository.isDynamicDependency(dependency)) {
            candidate = Optional.empty();
            this.dependencyReplacementInformation.put((Object)dependency, (Object)configuration, candidate);
        } else if (this.dependencyReplacementInformation.contains((Object)dependency, (Object)configuration)) {
            candidate = (Optional)this.dependencyReplacementInformation.get((Object)dependency, (Object)configuration);
            if (candidate == null || !candidate.isPresent()) {
                candidate = Optional.empty();
                this.dependencyReplacementInformation.remove((Object)dependency, (Object)configuration);
            }
        } else {
            candidate = Optional.empty();
            for (DependencyReplacementHandler handler : this.getReplacementHandlers()) {
                try {
                    Optional dependencyReplacementResult = ((DependencyReplacer)handler.getReplacer().get()).get((net.neoforged.gradle.dsl.common.extensions.dependency.replacement.Context)new Context(this.project, configuration, dependency, null));
                    if (!dependencyReplacementResult.isPresent()) continue;
                    candidate = dependencyReplacementResult;
                    break;
                }
                catch (Exception exception) {
                    throw new GradleException("Uncaught exception while processing replacement of dependency " + dependency.getGroup() + ":" + dependency.getName() + " using handler " + handler + ": " + exception.getMessage(), (Throwable)exception);
                }
            }
            if (!this.dependencyReplacementInformation.contains((Object)dependency, (Object)configuration)) {
                this.dependencyReplacementInformation.put((Object)dependency, (Object)configuration, candidate);
            }
        }
        if (candidate.isPresent()) {
            ReplacementResult result = (ReplacementResult)candidate.get();
            this.handleDependencyReplacement(configuration, (Dependency)dependency, result);
        }
    }

    @VisibleForTesting
    void handleDependencyReplacement(Configuration configuration, Dependency dependency, ReplacementResult result) {
        IdeManagementExtension ideManagementExtension;
        TaskProvider<? extends WithOutput> sourceTask;
        configuration.getDependencies().remove((Object)dependency);
        List targetConfigurations = ConfigurationUtils.findReplacementConfigurations((Project)this.project, (Configuration)configuration);
        Entry newRepoEntry = this.createDummyDependency(dependency, result);
        boolean requiresSourcesJar = result.getSourcesJar() != null;
        String rawArtifactSelectorName = CommonRuntimeUtils.buildTaskName((String)"selectRawArtifact", (Dependency)newRepoEntry.getDependency());
        String sourceArtifactSelectorName = requiresSourcesJar ? CommonRuntimeUtils.buildTaskName((String)"selectSourceArtifact", (Dependency)newRepoEntry.getDependency()) : null;
        boolean createsNewTasks = !this.project.getTasks().getNames().contains(rawArtifactSelectorName) || requiresSourcesJar && !this.project.getTasks().getNames().contains(sourceArtifactSelectorName);
        TaskProvider<? extends WithOutput> rawTask = this.createOrLookupRawTask(dependency, result, rawArtifactSelectorName, newRepoEntry);
        TaskProvider<? extends WithOutput> taskProvider = sourceTask = requiresSourcesJar ? this.createOrLookupSourcesTask(dependency, result, sourceArtifactSelectorName, newRepoEntry) : null;
        if (result instanceof ReplacementAware) {
            ReplacementAware replacementAware = (ReplacementAware)result;
            replacementAware.onTasksCreated(rawTask, sourceTask);
        }
        if (createsNewTasks && (ideManagementExtension = (IdeManagementExtension)this.getProject().getExtensions().getByType(IdeManagementExtension.class)).isIdeImportInProgress()) {
            ideManagementExtension.registerTaskToRun(rawTask);
            if (sourceTask != null) {
                ideManagementExtension.registerTaskToRun(sourceTask);
            }
            result.getAdditionalIdePostSyncTasks().forEach(ideManagementExtension::registerTaskToRun);
        }
        for (Configuration targetConfiguration : targetConfigurations) {
            Provider<ConfigurableFileCollection> replacedDependency = this.createDependencyFromTask(rawTask);
            this.project.getDependencies().addProvider(targetConfiguration.getName(), replacedDependency);
            targetConfiguration.getDependencies().add((Object)newRepoEntry.getDependency());
            this.originalDependencyLookup.put((Object)newRepoEntry.getDependency(), (Object)targetConfiguration, (Object)dependency);
        }
    }

    private TaskProvider<? extends WithOutput> createOrLookupSourcesTask(Dependency dependency, ReplacementResult result, String sourceArtifactSelectorName, Entry newRepoEntry) {
        if (this.project.getTasks().getNames().contains(sourceArtifactSelectorName)) {
            return this.project.getTasks().named(sourceArtifactSelectorName, WithOutput.class);
        }
        Repository repository = (Repository)this.project.getExtensions().getByType(Repository.class);
        return this.project.getTasks().register(sourceArtifactSelectorName, ArtifactFromOutput.class, artifactFromOutput -> {
            artifactFromOutput.setGroup("neogradle/dependencies");
            artifactFromOutput.setDescription(String.format("Selects the source artifact from the %s dependency and puts it in the Ivy repository", dependency));
            artifactFromOutput.getInput().set(result.getSourcesJar().flatMap(OutputSpecification::getOutput));
            artifactFromOutput.getOutput().set((Provider)repository.createOutputFor(newRepoEntry, Repository.Variant.SOURCES_CLASSIFIER));
            artifactFromOutput.dependsOn(new Object[]{result.getSourcesJar()});
        });
    }

    private TaskProvider<? extends WithOutput> createOrLookupRawTask(Dependency dependency, ReplacementResult result, String rawArtifactSelectorName, Entry newRepoEntry) {
        if (this.project.getTasks().getNames().contains(rawArtifactSelectorName)) {
            return this.project.getTasks().named(rawArtifactSelectorName, WithOutput.class);
        }
        Repository repository = (Repository)this.project.getExtensions().getByType(Repository.class);
        return this.project.getTasks().register(rawArtifactSelectorName, ArtifactFromOutput.class, artifactFromOutput -> {
            artifactFromOutput.setGroup("neogradle/dependencies");
            artifactFromOutput.setDescription(String.format("Selects the raw artifact from the %s dependency and puts it in the Ivy repository", dependency));
            artifactFromOutput.getInput().set(result.getRawJar().flatMap(OutputSpecification::getOutput));
            artifactFromOutput.getOutput().set((Provider)repository.createOutputFor(newRepoEntry, Repository.Variant.RETAINED_CLASSIFIER));
            artifactFromOutput.dependsOn(new Object[]{result.getRawJar()});
        });
    }

    @VisibleForTesting
    Entry createDummyDependency(Dependency dependency, ReplacementResult result) {
        if (!(dependency instanceof ExternalModuleDependency)) {
            throw new IllegalStateException("Only ExternalModuleDependency is supported for dependency replacement");
        }
        ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)dependency;
        if (result instanceof ReplacementAware) {
            ReplacementAware replacementAware = (ReplacementAware)result;
            externalModuleDependency = replacementAware.getReplacementDependency(externalModuleDependency);
        }
        Repository extension = (Repository)this.project.getExtensions().getByType(Repository.class);
        return extension.withEntry((EntryDefinition)this.project.getObjects().newInstance(RepoEntryDefinition.class, new Object[]{this.project, externalModuleDependency, result.getDependencies(), result.getSourcesJar() != null}));
    }

    public Provider<ConfigurableFileCollection> createDependencyFromTask(TaskProvider<? extends WithOutput> task) {
        return task.map(taskWithOutput -> this.project.files(new Object[]{taskWithOutput.getOutput()}));
    }
}

