/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.base;

import java.util.List;
import net.neoforged.gradle.common.extensions.base.WithPropertyLookup;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;

public abstract class WithEnabledProperty
extends WithPropertyLookup {
    private final String prefix;

    public WithEnabledProperty(Project project, String prefix) {
        super(project);
        this.prefix = prefix;
        this.getIsEnabled().convention(this.getBooleanProperty("enabled").orElse((Object)true));
    }

    public WithEnabledProperty(WithEnabledProperty parent, String prefix) {
        super(parent.project);
        this.prefix = String.format("%s.%s", parent.prefix, prefix);
        this.getIsEnabled().convention(parent.getIsEnabled().zip(this.getBooleanProperty("enabled"), (parentEnabled, enabled) -> parentEnabled != false && enabled != false).orElse((Object)true));
    }

    public abstract Property<Boolean> getIsEnabled();

    @Override
    protected Provider<String> getStringProperty(String propertyName) {
        return super.getStringProperty(String.format("%s.%s", this.prefix, propertyName));
    }

    @Override
    protected Provider<Boolean> getBooleanProperty(String propertyName) {
        return super.getBooleanProperty(String.format("%s.%s", this.prefix, propertyName));
    }

    @Override
    protected Provider<List<String>> getSpaceSeparatedListProperty(String propertyName) {
        return super.getSpaceSeparatedListProperty(String.format("%s.%s", this.prefix, propertyName));
    }
}

