/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.caching;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.gradle.common.util.hash.HashCode;
import net.neoforged.gradle.common.util.hash.HashFunction;
import net.neoforged.gradle.common.util.hash.Hasher;
import net.neoforged.gradle.common.util.hash.Hashing;
import net.neoforged.gradle.util.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.tasks.TaskInputs;

public abstract class CentralCacheService
implements BuildService<Parameters> {
    public static final String CACHING_PROPERTY_PREFIX = "net.neoforged.gradle.caching.";
    public static final String CACHE_DIRECTORY_PROPERTY = "net.neoforged.gradle.caching.cacheDirectory";
    public static final String LOG_CACHE_HITS_PROPERTY = "net.neoforged.gradle.caching.logCacheHits";
    public static final String MAX_CACHE_SIZE_PROPERTY = "net.neoforged.gradle.caching.maxCacheSize";
    public static final String DEBUG_CACHE_PROPERTY = "net.neoforged.gradle.caching.debug";
    public static final String IS_ENABLED_PROPERTY = "net.neoforged.gradle.caching.enabled";
    public static final String HEALTHY_FILE_NAME = "healthy";
    private final LockManager lockManager = new LockManager();

    public static void register(Project project, String name, boolean isolated) {
        project.getGradle().getSharedServices().registerIfAbsent(name, CentralCacheService.class, spec -> {
            if (isolated) {
                spec.getMaxParallelUsages().set((Object)1);
            }
            ((Parameters)spec.getParameters()).getCacheDirectory().fileProvider(project.getProviders().gradleProperty(CACHE_DIRECTORY_PROPERTY).map(File::new).orElse((Object)new File(new File(project.getGradle().getGradleUserHomeDir(), "caches"), name)));
            ((Parameters)spec.getParameters()).getLogCacheHits().set(project.getProviders().gradleProperty(LOG_CACHE_HITS_PROPERTY).map(Boolean::parseBoolean).orElse((Object)false));
            ((Parameters)spec.getParameters()).getMaxCacheSize().set(project.getProviders().gradleProperty(MAX_CACHE_SIZE_PROPERTY).map(Integer::parseInt).orElse((Object)100));
            ((Parameters)spec.getParameters()).getDebugCache().set(project.getProviders().gradleProperty(DEBUG_CACHE_PROPERTY).map(Boolean::parseBoolean).orElse((Object)false));
            ((Parameters)spec.getParameters()).getIsEnabled().set(project.getProviders().gradleProperty(IS_ENABLED_PROPERTY).map(Boolean::parseBoolean).orElse((Object)true));
        });
    }

    public void cleanCache(Task cleaningTask) {
        if (!((Boolean)((Parameters)this.getParameters()).getIsEnabled().get()).booleanValue()) {
            this.debugLog(cleaningTask, "Cache is disabled, skipping clean");
            return;
        }
        File cacheDirectory = ((Directory)((Parameters)this.getParameters()).getCacheDirectory().get()).getAsFile();
        if (cacheDirectory.exists()) {
            try (Stream<Path> stream = Files.walk(cacheDirectory.toPath(), new FileVisitOption[0]);){
                Set lockFilesToDelete = stream.filter(path -> path.getFileName().toString().equals("lock")).sorted(Comparator.comparingLong(p -> p.toFile().lastModified()).reversed()).skip(((Integer)((Parameters)this.getParameters()).getMaxCacheSize().get()).intValue()).collect(Collectors.toSet());
                for (Path path2 : lockFilesToDelete) {
                    File cacheFileDirectory = path2.getParent().toFile();
                    this.debugLog(cleaningTask, "Deleting cache directory for clean: " + cacheFileDirectory.getAbsolutePath());
                    FileUtils.delete((Path)cacheFileDirectory.toPath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void doCached(Task task, DoCreate onCreate, Provider<RegularFile> target) throws Throwable {
        if (!((Boolean)((Parameters)this.getParameters()).getIsEnabled().get()).booleanValue()) {
            this.debugLog(task, "Cache is disabled, skipping cache");
            onCreate.create();
            return;
        }
        TaskHasher hasher = new TaskHasher(task);
        String hashDirectoryName = hasher.create().toString();
        Directory cacheDirectory = ((Directory)((Parameters)this.getParameters()).getCacheDirectory().get()).dir(hashDirectoryName);
        RegularFile targetFile = (RegularFile)target.get();
        this.debugLog(task, "Cache directory: " + cacheDirectory.getAsFile().getAbsolutePath());
        this.debugLog(task, "Target file: " + targetFile.getAsFile().getAbsolutePath());
        File lockFile = new File(cacheDirectory.getAsFile(), "lock");
        this.debugLog(task, "Lock file: " + lockFile.getAbsolutePath());
        this.executeCacheLookupOrCreation(task, onCreate, lockFile, cacheDirectory, targetFile);
        this.debugLog(task, "Cached task: " + task.getPath() + " finished");
    }

    private void executeCacheLookupOrCreation(Task task, DoCreate onCreate, File lockFile, Directory cacheDirectory, RegularFile targetFile) throws Throwable {
        if (!lockFile.exists()) {
            this.debugLog(task, "Lock file does not exist: " + lockFile.getAbsolutePath());
            try {
                lockFile.getParentFile().mkdirs();
                lockFile.createNewFile();
            }
            catch (IOException e) {
                throw new GradleException("Failed to create lock file: " + lockFile.getAbsolutePath(), (Throwable)e);
            }
        }
        this.debugLog(task, "Acquiring lock on file: " + lockFile.getAbsolutePath());
        try (FileBasedLock fileBasedLock = this.lockManager.createLock(task, lockFile);){
            try {
                fileBasedLock.updateAccessTime();
                this.debugLog(task, "Lock acquired on file: " + lockFile.getAbsolutePath());
                this.executeCacheLookupOrCreationLocked(task, onCreate, cacheDirectory, targetFile.getAsFile(), fileBasedLock.hasPreviousFailure());
                this.debugLog(task, "Releasing lock on file: " + lockFile.getAbsolutePath());
            }
            catch (Exception ex) {
                this.debugLog(task, "Exception occurred while executing cached task: " + targetFile.getAsFile().getAbsolutePath(), ex);
                fileBasedLock.markAsFailed();
                throw new GradleException("Cached execution failed for: " + task.getName(), (Throwable)ex);
            }
        }
    }

    private void executeCacheLookupOrCreationLocked(Task task, DoCreate onCreate, Directory cacheDirectory, File targetFile, boolean failedPreviously) throws Throwable {
        File cacheFile = new File(cacheDirectory.getAsFile(), targetFile.getName());
        File noCacheFile = new File(cacheDirectory.getAsFile(), "nocache");
        if (failedPreviously) {
            this.debugLog(task, "Last cache run failed: " + cacheFile.getAbsolutePath());
            Files.deleteIfExists(cacheFile.toPath());
            Files.deleteIfExists(noCacheFile.toPath());
        }
        if (noCacheFile.exists()) {
            this.debugLog(task, "Last cache run indicated no output: " + noCacheFile.getAbsolutePath());
            this.logCacheHit(task, noCacheFile);
            task.setDidWork(false);
            Files.deleteIfExists(targetFile.toPath());
            return;
        }
        if (cacheFile.exists()) {
            this.debugLog(task, "Cached file exists: " + cacheFile.getAbsolutePath());
            if (targetFile.exists() && Hashing.hashFile(cacheFile).equals(Hashing.hashFile(targetFile))) {
                this.debugLog(task, "Cached file equals target file");
                task.setDidWork(false);
                this.logCacheEquals(task, cacheFile);
                return;
            }
            this.debugLog(task, "Cached file does not equal target file");
            this.logCacheHit(task, cacheFile);
            Files.deleteIfExists(targetFile.toPath());
            Files.copy(cacheFile.toPath(), targetFile.toPath(), new CopyOption[0]);
            task.setDidWork(false);
        } else {
            this.debugLog(task, "Cached file does not exist: " + cacheFile.getAbsolutePath());
            this.logCacheMiss(task);
            this.debugLog(task, "Creating output: " + targetFile.getAbsolutePath());
            File createdFile = onCreate.create();
            this.debugLog(task, "Created output: " + createdFile.getAbsolutePath());
            if (!createdFile.exists()) {
                this.debugLog(task, "No output was created: " + createdFile.getAbsolutePath());
                Files.createFile(noCacheFile.toPath(), new FileAttribute[0]);
                Files.deleteIfExists(cacheFile.toPath());
            } else {
                this.debugLog(task, "Output was created: " + createdFile.getAbsolutePath());
                Files.deleteIfExists(noCacheFile.toPath());
                Files.copy(createdFile.toPath(), cacheFile.toPath(), new CopyOption[0]);
            }
            task.setDidWork(true);
        }
    }

    private void logCacheEquals(Task task, File cacheFile) {
        if (((Boolean)((Parameters)this.getParameters()).getLogCacheHits().get()).booleanValue()) {
            task.getLogger().lifecycle("Cache equal for task {} from {}", new Object[]{task.getPath(), cacheFile.getAbsolutePath()});
        }
    }

    private void logCacheHit(Task task, File cacheFile) {
        if (((Boolean)((Parameters)this.getParameters()).getLogCacheHits().get()).booleanValue()) {
            task.getLogger().lifecycle("Cache hit for task {} from {}", new Object[]{task.getPath(), cacheFile.getAbsolutePath()});
        }
    }

    private void logCacheMiss(Task task) {
        if (((Boolean)((Parameters)this.getParameters()).getLogCacheHits().get()).booleanValue()) {
            task.getLogger().lifecycle("Cache miss for task {}", new Object[]{task.getPath()});
        }
    }

    private void debugLog(Task task, String message) {
        if (((Boolean)((Parameters)this.getParameters()).getDebugCache().get()).booleanValue()) {
            task.getLogger().lifecycle(" > [" + new Date(System.currentTimeMillis()) + "] (" + ProcessHandle.current().pid() + "): " + message);
        }
    }

    private void debugLog(Task task, String message, Exception e) {
        if (((Boolean)((Parameters)this.getParameters()).getDebugCache().get()).booleanValue()) {
            task.getLogger().lifecycle(" > [" + new Date(System.currentTimeMillis()) + "] (" + ProcessHandle.current().pid() + "): " + message, (Throwable)e);
        }
    }

    private final class LockManager {
        private LockManager() {
        }

        public FileBasedLock createLock(Task task, File lockFile) {
            if (WindowsFileBasedLock.isSupported()) {
                return new WindowsFileBasedLock(task, lockFile);
            }
            return new IOControlledFileBasedLock(task, lockFile);
        }
    }

    public static interface Parameters
    extends BuildServiceParameters {
        public DirectoryProperty getCacheDirectory();

        public Property<Boolean> getLogCacheHits();

        public Property<Integer> getMaxCacheSize();

        public Property<Boolean> getDebugCache();

        public Property<Boolean> getIsEnabled();
    }

    public static interface DoCreate {
        public File create() throws Throwable;
    }

    private final class TaskHasher {
        private final HashFunction hashFunction = Hashing.sha256();
        private final Hasher hasher = this.hashFunction.newHasher();
        private final Task task;

        public TaskHasher(Task task) {
            this.task = task;
        }

        public void hash() throws IOException {
            CentralCacheService.this.debugLog(this.task, "Hashing task: " + this.task.getPath());
            this.hasher.putString(this.task.getClass().getName());
            TaskInputs taskInputs = this.task.getInputs();
            this.hash(taskInputs);
        }

        public void hash(TaskInputs inputs) throws IOException {
            CentralCacheService.this.debugLog(this.task, "Hashing task inputs: " + this.task.getPath());
            inputs.getProperties().forEach((key, value) -> {
                CentralCacheService.this.debugLog(this.task, "Hashing task input property: " + key);
                this.hasher.putString((CharSequence)key);
                CentralCacheService.this.debugLog(this.task, "Hashing task input property value: " + value);
                this.hasher.put(value, false);
            });
            for (File file : inputs.getFiles()) {
                for (Path path : Files.walk(file.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList()) {
                    CentralCacheService.this.debugLog(this.task, "Hashing task input file: " + path.toAbsolutePath());
                    this.hasher.putString(path.getFileName().toString());
                    HashCode code = this.hashFunction.hashFile(path.toFile());
                    CentralCacheService.this.debugLog(this.task, "Hashing task input file hash: " + code);
                    this.hasher.putHash(code);
                }
            }
        }

        public HashCode create() throws IOException {
            this.hash();
            return this.hasher.hash();
        }
    }

    private static interface FileBasedLock
    extends AutoCloseable {
        public void updateAccessTime();

        public boolean hasPreviousFailure();

        public void markAsFailed();
    }

    private final class PIDBasedFileLock
    implements AutoCloseable {
        private final Task task;
        private final File lockFile;

        private PIDBasedFileLock(Task task, File lockFile) {
            this.task = task;
            this.lockFile = lockFile;
            this.lockFile();
        }

        private void lockFile() {
            while (!this.attemptFileLock()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Failed to acquire lock on file: " + this.lockFile.getAbsolutePath(), e);
                }
            }
        }

        private boolean attemptFileLock() {
            try {
                if (!this.lockFile.exists()) {
                    Files.write(this.lockFile.toPath(), String.valueOf(ProcessHandle.current().pid()).getBytes(), StandardOpenOption.CREATE_NEW);
                    return true;
                }
                Iterator<String> iterator = Files.readAllLines(this.lockFile.toPath()).iterator();
                if (iterator.hasNext()) {
                    String s = iterator.next();
                    int pid = Integer.parseInt(s);
                    if (ProcessHandle.current().pid() == (long)pid) {
                        CentralCacheService.this.debugLog(this.task, "Lock file is owned by current process: " + this.lockFile.getAbsolutePath() + " pid: " + pid);
                        return true;
                    }
                    if (ProcessHandle.of(pid).isEmpty()) {
                        CentralCacheService.this.debugLog(this.task, "Lock file is owned by a killed process: " + this.lockFile.getAbsolutePath() + " taking over. Old pid: " + pid);
                        Files.write(this.lockFile.toPath(), String.valueOf(ProcessHandle.current().pid()).getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
                        return true;
                    }
                    CentralCacheService.this.debugLog(this.task, "Lock file is owned by another process: " + this.lockFile.getAbsolutePath() + " pid: " + pid);
                    return false;
                }
                CentralCacheService.this.debugLog(this.task, "Lock file is empty: " + this.lockFile.getAbsolutePath());
                Files.write(this.lockFile.toPath(), String.valueOf(ProcessHandle.current().pid()).getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
                return true;
            }
            catch (Exception e) {
                CentralCacheService.this.debugLog(this.task, "Failed to acquire lock on file: " + this.lockFile.getAbsolutePath() + " -  Failure message: " + e.getLocalizedMessage(), e);
                return false;
            }
        }

        @Override
        public void close() throws Exception {
            CentralCacheService.this.debugLog(this.task, "Releasing lock on file: " + this.lockFile.getAbsolutePath());
            Files.write(this.lockFile.toPath(), (Iterable<? extends CharSequence>)Lists.newArrayList(), StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    private final class IOControlledFileBasedLock
    extends HealthFileUsingFileBasedLock {
        private final Task task;
        private final File lockFile;
        private final PIDBasedFileLock pidBasedFileLock;

        private IOControlledFileBasedLock(Task task, File lockFile) {
            super(new File(lockFile.getParentFile(), CentralCacheService.HEALTHY_FILE_NAME));
            this.task = task;
            this.lockFile = lockFile;
            this.pidBasedFileLock = new PIDBasedFileLock(task, lockFile);
        }

        @Override
        public void updateAccessTime() {
            if (!this.lockFile.setLastModified(System.currentTimeMillis())) {
                throw new RuntimeException("Failed to update access time for lock file: " + this.lockFile.getAbsolutePath());
            }
            CentralCacheService.this.debugLog(this.task, "Updated access time for lock file: " + this.lockFile.getAbsolutePath());
        }

        @Override
        public void close() throws Exception {
            super.close();
            this.pidBasedFileLock.close();
            CentralCacheService.this.debugLog(this.task, "Lock file closed: " + this.lockFile.getAbsolutePath());
        }
    }

    private final class NioBasedFileLock
    implements AutoCloseable {
        private final Task task;
        private final File lockFile;
        private final RandomAccessFile lockFileAccess;
        private final FileChannel fileChannel;
        private final FileLock fileLock;

        public static boolean isSupported() {
            return SystemUtils.IS_OS_WINDOWS;
        }

        public NioBasedFileLock(Task task, File lockFile) {
            if (!NioBasedFileLock.isSupported()) {
                throw new UnsupportedOperationException("NIO file locks are not supported on this platform");
            }
            this.task = task;
            this.lockFile = lockFile;
            try {
                this.lockFileAccess = new RandomAccessFile(lockFile, "rw");
                this.fileChannel = this.lockFileAccess.getChannel();
                this.fileLock = this.fileChannel.lock();
                CentralCacheService.this.debugLog(task, "Acquired lock on file: " + lockFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to acquire lock on file: " + lockFile.getAbsolutePath(), e);
            }
        }

        @Override
        public void close() throws Exception {
            this.fileLock.release();
            this.fileChannel.close();
            this.lockFileAccess.close();
            CentralCacheService.this.debugLog(this.task, "Released lock on file: " + this.lockFile.getAbsolutePath());
        }
    }

    private final class WindowsFileBasedLock
    extends HealthFileUsingFileBasedLock {
        private final Task task;
        private final File lockFile;
        private final NioBasedFileLock nioBasedFileLock;

        private static boolean isSupported() {
            return SystemUtils.IS_OS_WINDOWS;
        }

        private WindowsFileBasedLock(Task task, File lockFile) {
            super(new File(lockFile.getParentFile(), CentralCacheService.HEALTHY_FILE_NAME));
            if (!WindowsFileBasedLock.isSupported() || !NioBasedFileLock.isSupported()) {
                throw new UnsupportedOperationException("Windows file locks are not supported on this platform, or NIO based locking is not supported!");
            }
            this.task = task;
            this.lockFile = lockFile;
            this.nioBasedFileLock = new NioBasedFileLock(task, lockFile);
        }

        @Override
        public void updateAccessTime() {
            if (!this.lockFile.setLastModified(System.currentTimeMillis())) {
                throw new RuntimeException("Failed to update access time for lock file: " + this.lockFile.getAbsolutePath());
            }
            CentralCacheService.this.debugLog(this.task, "Updated access time for lock file: " + this.lockFile.getAbsolutePath());
        }

        @Override
        public void close() throws Exception {
            super.close();
            this.nioBasedFileLock.close();
            CentralCacheService.this.debugLog(this.task, "Lock file closed: " + this.lockFile.getAbsolutePath());
        }
    }

    private static abstract class HealthFileUsingFileBasedLock
    implements FileBasedLock {
        private final File healthyFile;
        private boolean hasFailed = false;

        private HealthFileUsingFileBasedLock(File healthyFile) {
            this.healthyFile = healthyFile;
            if (this.healthyFile.exists() && !this.healthyFile.delete()) {
                throw new IllegalStateException("Failed to delete healthy marker file: " + this.healthyFile.getAbsolutePath());
            }
        }

        @Override
        public boolean hasPreviousFailure() {
            return this.hasFailed || !this.healthyFile.exists();
        }

        @Override
        public void markAsFailed() {
            this.hasFailed = true;
        }

        @Override
        public void close() throws Exception {
            if (!this.hasFailed) {
                this.healthyFile.createNewFile();
            } else if (this.healthyFile.exists() && !this.healthyFile.delete()) {
                throw new IllegalStateException("Failed to delete healthy marker file: " + this.healthyFile.getAbsolutePath());
            }
        }
    }
}

