/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.neoforged.gradle.common.caching.CentralCacheService;
import net.neoforged.gradle.common.runtime.tasks.DefaultRuntime;
import net.neoforged.gradle.common.runtime.tasks.action.DownloadFileAction;
import net.neoforged.gradle.common.util.FileCacheUtils;
import net.neoforged.gradle.common.util.SerializationUtils;
import net.neoforged.gradle.util.HashFunction;
import net.neoforged.gradle.util.TransformerUtils;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.ServiceReference;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class ListLibraries
extends DefaultRuntime {
    private static final Attributes.Name FORMAT = new Attributes.Name("Bundler-Format");

    public ListLibraries() {
        this.getLibrariesDirectory().convention(FileCacheUtils.getLibrariesCacheDirectory(this.getProject()).map(TransformerUtils.ensureExists()));
        this.getServerBundleFile().fileProvider(this.getRuntimeArguments().map(arguments -> {
            if (!arguments.containsKey("bundle")) {
                return null;
            }
            return new File((String)((Provider)arguments.get("bundle")).get());
        }));
        this.getOutputFileName().set((Object)"libraries.txt");
        this.getIsOffline().convention((Object)this.getProject().getGradle().getStartParameter().isOffline());
    }

    @Input
    public abstract Property<Boolean> getIsOffline();

    @ServiceReference(value="ng_libraries")
    public abstract Property<CentralCacheService> getLibrariesCache();

    @TaskAction
    public void run() throws IOException {
        File output = this.ensureFileWorkspaceReady(this.getOutput());
        try (FileSystem bundleFs = !this.getServerBundleFile().isPresent() ? null : FileSystems.newFileSystem(((RegularFile)this.getServerBundleFile().get()).getAsFile().toPath(), ((Object)((Object)this)).getClass().getClassLoader());){
            Set<File> libraries = bundleFs == null ? this.downloadAndListJsonLibraries() : this.unpackAndListBundleLibraries(bundleFs);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8));
            Iterator itr = libraries.stream().sorted(Comparator.naturalOrder()).iterator();
            while (itr.hasNext()) {
                writer.println("-e=" + ((File)itr.next()).getAbsolutePath());
            }
            writer.flush();
            writer.close();
        }
    }

    private List<FileList.Entry> listBundleLibraries(FileSystem bundleFs) throws IOException {
        Manifest mf;
        Path mfp = bundleFs.getPath("META-INF", "MANIFEST.MF");
        if (!Files.exists(mfp, new LinkOption[0])) {
            throw new RuntimeException("Input archive does not contain META-INF/MANIFEST.MF");
        }
        try (InputStream is = Files.newInputStream(mfp, new OpenOption[0]);){
            mf = new Manifest(is);
        }
        String format = mf.getMainAttributes().getValue(FORMAT);
        if (format == null) {
            throw new RuntimeException("Invalid bundler archive; missing format entry from manifest");
        }
        if (!"1.0".equals(format)) {
            throw new RuntimeException("Unsupported bundler format " + format + "; only 1.0 is supported");
        }
        return FileList.read(bundleFs.getPath("META-INF", "libraries.list")).entries;
    }

    private Set<PathAndUrl> listDownloadJsonLibraries() {
        JsonObject json = SerializationUtils.fromJson((File)this.getDownloadedVersionJsonFile().getAsFile().get(), JsonObject.class);
        HashSet<PathAndUrl> artifacts = new HashSet<PathAndUrl>();
        for (JsonElement libElement : json.getAsJsonArray("libraries")) {
            JsonObject downloads;
            JsonObject library = libElement.getAsJsonObject();
            if (!library.has("downloads") || !(downloads = library.get("downloads").getAsJsonObject()).has("artifact")) continue;
            JsonObject artifact = downloads.getAsJsonObject("artifact");
            artifacts.add(new PathAndUrl(artifact.get("path").getAsString(), artifact.get("url").getAsString(), artifact.get("sha1").getAsString()));
        }
        return artifacts;
    }

    private Set<File> unpackAndListBundleLibraries(FileSystem bundleFs) throws IOException {
        File outputDir = ((Directory)this.getLibrariesDirectory().get()).getAsFile();
        List<FileList.Entry> libraryPaths = this.listBundleLibraries(bundleFs);
        return libraryPaths.stream().map(entry -> {
            String path = String.format("META-INF/libraries/%s", ((FileList.Entry)entry).path);
            File output = new File(outputDir, path);
            try {
                if (!output.exists() || !HashFunction.SHA1.hash(output).equalsIgnoreCase(((FileList.Entry)entry).hash)) {
                    Files.copy(bundleFs.getPath(path, new String[0]), output.toPath(), new CopyOption[0]);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return output;
        }).collect(Collectors.toSet());
    }

    private Set<File> downloadAndListJsonLibraries() throws IOException {
        Set<PathAndUrl> libraryCoordinates = this.listDownloadJsonLibraries();
        File outputDirectory = ((Directory)this.getLibrariesDirectory().get()).getAsFile();
        HashSet<File> result = new HashSet<File>();
        WorkQueue executor = this.getWorkerExecutor().noIsolation();
        for (PathAndUrl libraryCoordinate : libraryCoordinates) {
            File outputFile = new File(outputDirectory, libraryCoordinate.path);
            executor.submit(DownloadFileAction.class, params -> {
                params.getUrl().set((Object)libraryCoordinate.url);
                params.getShouldValidateHash().set((Object)true);
                params.getSha1().set((Object)libraryCoordinate.hash);
                params.getOutputFile().set(outputFile);
                params.getIsOffline().set(this.getIsOffline());
            });
            result.add(outputFile);
        }
        executor.await();
        return result;
    }

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getServerBundleFile();

    @InputFile
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract RegularFileProperty getDownloadedVersionJsonFile();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract DirectoryProperty getLibrariesDirectory();

    private static final class PathAndUrl {
        private final String path;
        private final String url;
        private final String hash;

        private PathAndUrl(String path, String url, String hash) {
            this.path = path;
            this.url = url;
            this.hash = hash;
        }

        public String getPath() {
            return this.path;
        }

        public String getUrl() {
            return this.url;
        }

        public String getHash() {
            return this.hash;
        }
    }

    private static class FileList {
        private final List<Entry> entries;

        private FileList(List<Entry> entries) {
            this.entries = entries;
        }

        static FileList read(Path path) throws IOException {
            ArrayList<Entry> ret = new ArrayList<Entry>();
            for (String line : Files.readAllLines(path)) {
                String[] pts = line.split("\t");
                if (pts.length != 3) {
                    throw new IllegalStateException("Invalid file list line: " + line);
                }
                ret.add(new Entry(pts[0], pts[1], pts[2]));
            }
            return new FileList(ret);
        }

        private static final class Entry {
            private final String hash;
            private final String id;
            private final String path;

            private Entry(String hash, String id, String path) {
                this.hash = hash;
                this.id = id;
                this.path = path;
            }

            public String hash() {
                return this.hash;
            }

            public String id() {
                return this.id;
            }

            public String path() {
                return this.path;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || obj.getClass() != this.getClass()) {
                    return false;
                }
                Entry that = (Entry)obj;
                return Objects.equals(this.hash, that.hash) && Objects.equals(this.id, that.id) && Objects.equals(this.path, that.path);
            }

            public int hashCode() {
                return Objects.hash(this.hash, this.id, this.path);
            }

            public String toString() {
                return "Entry[hash=" + this.hash + ", id=" + this.id + ", path=" + this.path + ']';
            }
        }
    }
}

