/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runtime.tasks;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.runtime.tasks.RuntimeArgumentsImpl;
import net.neoforged.gradle.common.runtime.tasks.RuntimeMultiArgumentsImpl;
import net.neoforged.gradle.common.tasks.JavaRuntimeTask;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeArguments;
import net.neoforged.gradle.dsl.common.runtime.tasks.RuntimeMultiArguments;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;

@CacheableTask
public abstract class DefaultRuntime
extends JavaRuntimeTask
implements Runtime {
    private final RuntimeArguments arguments = (RuntimeArguments)this.getObjectFactory().newInstance(RuntimeArgumentsImpl.class, new Object[]{this.getProviderFactory()});
    private final RuntimeMultiArguments multiArguments = (RuntimeMultiArguments)this.getObjectFactory().newInstance(RuntimeMultiArgumentsImpl.class, new Object[]{this.getProviderFactory()});

    public DefaultRuntime() {
        this.setGroup("NeoGradle/runtimes");
        this.getStepsDirectory().convention(this.getRuntimeDirectory().dir("steps"));
        this.getOutputDirectory().convention(this.getStepsDirectory().flatMap(d -> this.getStepName().map(arg_0 -> ((Directory)d).dir(arg_0))));
        this.getOutputFileName().convention(this.getArguments().getOrDefault("outputExtension", this.getProviderFactory().provider(() -> "jar")).map(extension -> String.format("output.%s", extension)).orElse((Object)"output.jar"));
        this.getOutput().convention(this.getOutputDirectory().flatMap(d -> this.getOutputFileName().orElse((Object)"output.jar").map(arg_0 -> ((Directory)d).file(arg_0))));
        this.getRuntimeArguments().convention(this.getArguments().asMap().map(arguments -> {
            HashMap<String, Provider<String>> result = new HashMap<String, Provider<String>>((Map<String, Provider<String>>)arguments);
            this.buildRuntimeArguments(result);
            return result;
        }));
        this.getRuntimeData().convention(this.getSymbolicDataSources().map(dataSources -> dataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.getNeoFormArchive().getAsFileTree().matching(archive -> archive.include(new String[]{(String)entry.getValue()}))))));
        this.getOutputDirectory().finalizeValueOnRead();
    }

    @Nested
    public RuntimeArguments getArguments() {
        return this.arguments;
    }

    @Nested
    public RuntimeMultiArguments getMultiArguments() {
        return this.multiArguments;
    }

    public String getGroup() {
        String name = (String)this.getRuntimeName().getOrElse((Object)"unknown");
        return String.format("NeoGradle/Runtime/%s", name);
    }

    protected Provider<File> getFileInOutputDirectory(String fileName) {
        return this.getOutputDirectory().map(directory -> directory.file(fileName).getAsFile());
    }

    protected Provider<File> getFileInOutputDirectory(Provider<String> fileName) {
        return this.getOutputDirectory().flatMap(directory -> fileName.map(f -> directory.file(f).getAsFile()));
    }

    protected Provider<RegularFile> getRegularFileInOutputDirectory(Provider<String> fileName) {
        return this.getOutputDirectory().flatMap(directory -> fileName.map(arg_0 -> ((Directory)directory).file(arg_0)));
    }

    @Internal
    public abstract MapProperty<String, FileTree> getRuntimeData();

    @Input
    public abstract MapProperty<String, Provider<String>> getRuntimeArguments();

    protected void buildRuntimeArguments(Map<String, Provider<String>> arguments) {
        arguments.computeIfAbsent("output", key -> this.newProvider(((RegularFile)this.getOutput().get()).getAsFile().getAbsolutePath()));
        arguments.computeIfAbsent("outputDir", key -> this.newProvider(((Directory)this.getOutputDirectory().get()).getAsFile().getAbsolutePath()));
        arguments.computeIfAbsent("outputExtension", key -> this.newProvider(((String)this.getOutputFileName().get()).substring(((String)this.getOutputFileName().get()).lastIndexOf(46) + 1)));
        arguments.computeIfAbsent("outputFileName", key -> this.newProvider(this.getOutputFileName().get()));
        arguments.computeIfAbsent("stepsDir", key -> this.newProvider(((Directory)this.getStepsDirectory().get()).getAsFile().getAbsolutePath()));
        arguments.computeIfAbsent("stepName", key -> this.getStepName());
        arguments.computeIfAbsent("side", key -> this.getDistribution().map(DistributionType::getName));
        arguments.computeIfAbsent("minecraftVersion", key -> this.getMinecraftVersion().map(Object::toString));
        arguments.computeIfAbsent("javaVersion", key -> this.getJavaLauncher().map(launcher -> launcher.getMetadata().getLanguageVersion().toString()));
    }
}

