/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runs.tasks;

import java.util.List;
import java.util.Map;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.dsl.common.runs.run.DependencyHandler;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import org.gradle.api.file.Directory;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.SourceSet;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="This runs a game. It should not be cached.")
public abstract class RunExec
extends JavaExec {
    public static final String GROUP = "NeoGradle/Runs";

    public RunExec() {
        this.setGroup(GROUP);
        this.getMainClass().convention(this.getRun().flatMap(Run::getMainClass));
        this.doNotTrackState("This is a runnable task, which has no output.");
        JavaToolchainService service = (JavaToolchainService)this.getProject().getExtensions().getByType(JavaToolchainService.class);
        this.getJavaLauncher().convention(service.launcherFor(((JavaPluginExtension)this.getProject().getExtensions().getByType(JavaPluginExtension.class)).getToolchain()));
    }

    public void exec() {
        RunImpl run = (RunImpl)this.getRun().get();
        this.setWorkingDir(((Directory)run.getWorkingDirectory().get()).getAsFile());
        this.args((Iterable)run.getProgramArguments().get());
        this.jvmArgs((Iterable)run.getJvmArguments().get());
        this.environment((Map)run.getEnvironmentVariables().get());
        this.systemProperties((Map)run.getSystemProperties().get());
        ((List)run.getModSources().get()).stream().map(SourceSet::getRuntimeClasspath).forEach(xva$0 -> this.classpath(new Object[]{xva$0}));
        this.classpath(new Object[]{run.getClasspath()});
        this.classpath(new Object[]{((DependencyHandler)run.getDependencies().get()).getRuntimeConfiguration()});
        super.exec();
    }

    @Nested
    public abstract Property<Run> getRun();
}

