/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.base;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;

public abstract class WithPropertyLookup {
    protected final Project project;

    public WithPropertyLookup(Project project) {
        this.project = project;
    }

    protected Provider<String> getStringProperty(String propertyName) {
        return this.project.getProviders().gradleProperty("neogradle.subsystems." + propertyName);
    }

    protected Provider<Boolean> getBooleanProperty(String propertyName) {
        String fullPropertyName = "neogradle.subsystems." + propertyName;
        return this.project.getProviders().gradleProperty(fullPropertyName).map(value -> {
            try {
                return Boolean.valueOf(value);
            }
            catch (Exception e) {
                throw new GradleException("Gradle Property " + fullPropertyName + " is not set to a boolean value: '" + value + "'");
            }
        });
    }

    protected Provider<List<String>> getSpaceSeparatedListProperty(String propertyName) {
        return this.project.getProviders().gradleProperty("neogradle.subsystems." + propertyName).map(s -> Arrays.asList(s.split("\\s+")));
    }

    public Project getProject() {
        return this.project;
    }
}

