/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.neoforged.gradle.common.caching.CentralCacheService;
import net.neoforged.gradle.common.dependency.ExtraJarDependencyManager;
import net.neoforged.gradle.common.extensions.AccessTransformersExtension;
import net.neoforged.gradle.common.extensions.ConfigurationDataExtension;
import net.neoforged.gradle.common.extensions.ExtensionManager;
import net.neoforged.gradle.common.extensions.IdeManagementExtension;
import net.neoforged.gradle.common.extensions.MappingsExtension;
import net.neoforged.gradle.common.extensions.MinecraftArtifactCacheExtension;
import net.neoforged.gradle.common.extensions.MinecraftExtension;
import net.neoforged.gradle.common.extensions.ProjectEvaluationExtension;
import net.neoforged.gradle.common.extensions.ProjectHolderExtension;
import net.neoforged.gradle.common.extensions.dependency.replacement.ReplacementLogic;
import net.neoforged.gradle.common.extensions.repository.IvyRepository;
import net.neoforged.gradle.common.extensions.subsystems.SubsystemsExtension;
import net.neoforged.gradle.common.runs.ide.IdeRunIntegrationManager;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.runtime.definition.CommonRuntimeDefinition;
import net.neoforged.gradle.common.runtime.extensions.RuntimesExtension;
import net.neoforged.gradle.common.runtime.naming.OfficialNamingChannelConfigurator;
import net.neoforged.gradle.common.tasks.DisplayMappingsLicenseTask;
import net.neoforged.gradle.common.util.ProjectUtils;
import net.neoforged.gradle.common.util.SourceSetUtils;
import net.neoforged.gradle.common.util.TaskDependencyUtils;
import net.neoforged.gradle.common.util.exceptions.MultipleDefinitionsFoundException;
import net.neoforged.gradle.common.util.run.RunsUtil;
import net.neoforged.gradle.dsl.common.extensions.AccessTransformers;
import net.neoforged.gradle.dsl.common.extensions.ConfigurationData;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import net.neoforged.gradle.dsl.common.extensions.ProjectHolder;
import net.neoforged.gradle.dsl.common.extensions.RunnableSourceSet;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.repository.Repository;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Conventions;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.Configurations;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.IDE;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.Runs;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.SourceSets;
import net.neoforged.gradle.dsl.common.extensions.subsystems.conventions.ide.IDEA;
import net.neoforged.gradle.dsl.common.runs.run.DependencyHandler;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.type.RunType;
import net.neoforged.gradle.dsl.common.runtime.naming.NamingChannel;
import net.neoforged.gradle.dsl.common.util.ConfigurationUtils;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.attributes.Category;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.DefaultTaskExecutionRequest;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.jetbrains.gradle.ext.IdeaExtPlugin;

public class CommonProjectPlugin
implements Plugin<Project> {
    public static final String ASSETS_SERVICE = "ng_assets";
    public static final String LIBRARIES_SERVICE = "ng_libraries";
    public static final String ACCESS_TRANSFORMER_ELEMENTS_CONFIGURATION = "accessTransformerElements";
    public static final String ACCESS_TRANSFORMER_API_CONFIGURATION = "accessTransformerApi";
    public static final String ACCESS_TRANSFORMER_CONFIGURATION = "accessTransformer";
    static final String ACCESS_TRANSFORMER_CATEGORY = "accesstransformer";

    public void apply(Project project) {
        project.getExtensions().create("evaluation", ProjectEvaluationExtension.class, new Object[]{project});
        project.getPluginManager().apply(JavaPlugin.class);
        CentralCacheService.register(project, ASSETS_SERVICE);
        CentralCacheService.register(project, LIBRARIES_SERVICE);
        project.getPluginManager().apply(IdeaPlugin.class);
        project.getRootProject().getPluginManager().apply(IdeaExtPlugin.class);
        project.getPluginManager().apply(IdeaExtPlugin.class);
        project.getPluginManager().apply(EclipsePlugin.class);
        project.getExtensions().create("extensionManager", ExtensionManager.class, new Object[]{project});
        ExtensionManager extensionManager = (ExtensionManager)project.getExtensions().getByType(ExtensionManager.class);
        extensionManager.registerExtension("subsystems", Subsystems.class, p -> (SubsystemsExtension)p.getObjects().newInstance(SubsystemsExtension.class, new Object[]{p}));
        project.getExtensions().create(IdeManagementExtension.class, "ideManager", IdeManagementExtension.class, new Object[]{project});
        project.getExtensions().create("allRuntimes", RuntimesExtension.class, new Object[0]);
        project.getExtensions().create(Repository.class, "ivyDummyRepository", IvyRepository.class, new Object[]{project});
        project.getExtensions().create(MinecraftArtifactCache.class, "minecraftArtifactCache", MinecraftArtifactCacheExtension.class, new Object[]{project});
        project.getExtensions().create(DependencyReplacement.class, "dependencyReplacements", ReplacementLogic.class, new Object[]{project});
        AccessTransformers accessTransformers = (AccessTransformers)project.getExtensions().create(AccessTransformers.class, "accessTransformers", AccessTransformersExtension.class, new Object[]{project});
        extensionManager.registerExtension("minecraft", Minecraft.class, p -> (MinecraftExtension)p.getObjects().newInstance(MinecraftExtension.class, new Object[]{p}));
        extensionManager.registerExtension("mappings", Mappings.class, p -> (MappingsExtension)p.getObjects().newInstance(MappingsExtension.class, new Object[]{p}));
        project.getExtensions().create("clientExtraJarDependencyManager", ExtraJarDependencyManager.class, new Object[]{project});
        ConfigurationData configurationData = (ConfigurationData)project.getExtensions().create(ConfigurationData.class, "configurationData", ConfigurationDataExtension.class, new Object[]{project});
        OfficialNamingChannelConfigurator.getInstance().configure(project);
        project.getTasks().register("handleNamingLicense", DisplayMappingsLicenseTask.class, task -> task.getLicense().set(project.provider(() -> {
            Mappings mappings = (Mappings)project.getExtensions().getByType(Mappings.class);
            if (((Boolean)((NamingChannel)mappings.getChannel().get()).getHasAcceptedLicense().get()).booleanValue()) {
                return null;
            }
            return (String)((NamingChannel)mappings.getChannel().get()).getLicenseText().get();
        })));
        project.getRepositories().maven(e -> {
            e.setUrl((Object)"https://libraries.minecraft.net/");
            e.metadataSources(MavenArtifactRepository.MetadataSources::artifact);
        });
        ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).configureEach(sourceSet -> {
            sourceSet.getExtensions().create(ProjectHolder.class, "projectHolder", ProjectHolderExtension.class, new Object[]{project});
            sourceSet.getExtensions().create("runs", RunnableSourceSet.class, new Object[]{project});
            sourceSet.getExtensions().add("runtimeDefinition", (Object)project.getObjects().property(CommonRuntimeDefinition.class));
        });
        project.getExtensions().add("runTypes", (Object)project.getObjects().domainObjectContainer(RunType.class, name -> (RunType)project.getObjects().newInstance(RunType.class, new Object[]{name})));
        project.getExtensions().add("runs", (Object)project.getObjects().domainObjectContainer(Run.class, name -> RunsUtil.create(project, name)));
        this.setupAccessTransformerConfigurations(project, accessTransformers);
        IdeRunIntegrationManager.getInstance().setup(project);
        project.getTasks().named("clean", Delete.class, delete -> delete.delete(new Object[]{configurationData.getLocation()}));
        this.configureConventions(project);
        project.afterEvaluate(this::applyAfterEvaluate);
    }

    private void configureConventions(Project project) {
        Conventions conventions = ((Subsystems)project.getExtensions().getByType(Subsystems.class)).getConventions();
        if (!((Boolean)conventions.getIsEnabled().get()).booleanValue()) {
            return;
        }
        this.configureRunConventions(project, conventions);
        this.configureSourceSetConventions(project, conventions);
        this.configureIDEConventions(project, conventions);
    }

    private void configureSourceSetConventions(Project project, Conventions conventions) {
        SourceSets sourceSets = conventions.getSourceSets();
        Configurations configurations = conventions.getConfigurations();
        if (!((Boolean)sourceSets.getIsEnabled().get()).booleanValue()) {
            return;
        }
        if (((Boolean)configurations.getIsEnabled().get()).booleanValue()) {
            ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).configureEach(sourceSet -> {
                Configuration sourceSetLocalRuntimeConfiguration = (Configuration)project.getConfigurations().maybeCreate(ConfigurationUtils.getSourceSetName((SourceSet)sourceSet, (String)((String)configurations.getLocalRuntimeConfigurationPostFix().get())));
                project.getConfigurations().maybeCreate(ConfigurationUtils.getSourceSetName((SourceSet)sourceSet, (String)((String)configurations.getRunRuntimeConfigurationPostFix().get())));
                Configuration sourceSetRuntimeClasspath = (Configuration)project.getConfigurations().maybeCreate(sourceSet.getRuntimeClasspathConfigurationName());
                sourceSetRuntimeClasspath.extendsFrom(new Configuration[]{sourceSetLocalRuntimeConfiguration});
            });
        }
        ProjectUtils.afterEvaluate(project, () -> project.getExtensions().configure("runs", runs -> runs.configureEach(run -> {
            if (((Boolean)sourceSets.getShouldMainSourceSetBeAutomaticallyAddedToRuns().get()).booleanValue()) {
                run.getModSources().add(((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).getByName("main"));
            }
            if (((Boolean)sourceSets.getShouldSourceSetsLocalRunRuntimesBeAutomaticallyAddedToRuns().get()).booleanValue() && ((Boolean)configurations.getIsEnabled().get()).booleanValue()) {
                ((List)run.getModSources().get()).forEach(sourceSet -> ((DependencyHandler)run.getDependencies().get()).getRuntime().add((FileCollection)project.getConfigurations().getByName(ConfigurationUtils.getSourceSetName((SourceSet)sourceSet, (String)((String)configurations.getRunRuntimeConfigurationPostFix().get())))));
            }
        })));
    }

    private void configureRunConventions(Project project, Conventions conventions) {
        Configurations configurations = conventions.getConfigurations();
        Runs runs = conventions.getRuns();
        if (!((Boolean)runs.getIsEnabled().get()).booleanValue()) {
            return;
        }
        if (((Boolean)runs.getShouldDefaultRunsBeCreated().get()).booleanValue()) {
            NamedDomainObjectContainer runTypes = (NamedDomainObjectContainer)project.getExtensions().getByName("runTypes");
            runTypes.whenObjectAdded(runType -> project.getExtensions().configure("runs", runContainer -> {
                if (runContainer.getAsMap().containsKey(runType.getName())) {
                    return;
                }
                runContainer.create(runType.getName(), run -> run.configure(runType));
            }));
        }
        if (!((Boolean)configurations.getIsEnabled().get()).booleanValue()) {
            return;
        }
        Configuration runRuntimeConfiguration = (Configuration)project.getConfigurations().maybeCreate((String)configurations.getRunRuntimeConfigurationName().get());
        project.getExtensions().configure("runs", runContainer -> runContainer.configureEach(run -> {
            Configuration runSpecificRuntimeConfiguration = (Configuration)project.getConfigurations().maybeCreate(ConfigurationUtils.getRunName((Run)run, (String)((String)configurations.getPerRunRuntimeConfigurationPostFix().get())));
            ((DependencyHandler)run.getDependencies().get()).getRuntime().add((FileCollection)runRuntimeConfiguration);
            ((DependencyHandler)run.getDependencies().get()).getRuntime().add((FileCollection)runSpecificRuntimeConfiguration);
        }));
    }

    private void configureIDEConventions(Project project, Conventions conventions) {
        IDE ideConventions = conventions.getIde();
        if (!((Boolean)ideConventions.getIsEnabled().get()).booleanValue()) {
            return;
        }
        this.configureIDEAIDEConventions(project, ideConventions);
    }

    private void configureIDEAIDEConventions(Project project, IDE ideConventions) {
        IDEA ideaConventions = ideConventions.getIdea();
        if (!((Boolean)ideaConventions.getIsEnabled().get()).booleanValue()) {
            return;
        }
        IdeManagementExtension ideManagementExtension = (IdeManagementExtension)project.getExtensions().getByType(IdeManagementExtension.class);
        ideManagementExtension.onIdea((innerProject, idea, ideaExtension) -> {
            if (!((Boolean)ideaConventions.getIsEnabled().get()).booleanValue()) {
                return;
            }
            if (((Boolean)ideaConventions.getShouldUsePostSyncTask().get()).booleanValue()) {
                return;
            }
            StartParameter startParameter = innerProject.getGradle().getStartParameter();
            ArrayList<DefaultTaskExecutionRequest> taskRequests = new ArrayList<DefaultTaskExecutionRequest>(startParameter.getTaskRequests());
            TaskProvider<? extends Task> ideImportTask = ideManagementExtension.getOrCreateIdeImportTask();
            ArrayList<String> taskPaths = new ArrayList<String>();
            String ideImportTaskName = ideImportTask.getName();
            String projectPath = innerProject.getPath();
            String taskPath = ideImportTaskName.startsWith(":") ? (projectPath.equals(":") ? ideImportTaskName : String.format("%s%s", projectPath, ideImportTaskName)) : (projectPath.equals(":") ? String.format(":%s", ideImportTaskName) : String.format("%s:%s", projectPath, ideImportTaskName));
            taskPaths.add(taskPath);
            taskRequests.add(new DefaultTaskExecutionRequest(taskPaths));
            startParameter.setTaskRequests(taskRequests);
        });
        IdeRunIntegrationManager.getInstance().configureIdeaConventions(project, ideaConventions);
    }

    private void setupAccessTransformerConfigurations(Project project, AccessTransformers accessTransformersExtension) {
        Configuration accessTransformerElements = (Configuration)project.getConfigurations().maybeCreate(ACCESS_TRANSFORMER_ELEMENTS_CONFIGURATION);
        Configuration accessTransformerApi = (Configuration)project.getConfigurations().maybeCreate(ACCESS_TRANSFORMER_API_CONFIGURATION);
        Configuration accessTransformer = (Configuration)project.getConfigurations().maybeCreate(ACCESS_TRANSFORMER_CONFIGURATION);
        accessTransformerApi.setCanBeConsumed(false);
        accessTransformerApi.setCanBeResolved(false);
        accessTransformer.setCanBeConsumed(false);
        accessTransformer.setCanBeResolved(true);
        accessTransformerElements.setCanBeConsumed(true);
        accessTransformerElements.setCanBeResolved(false);
        accessTransformerElements.setCanBeDeclared(false);
        Action action = attributes -> attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)project.getObjects().named(Category.class, ACCESS_TRANSFORMER_CATEGORY));
        accessTransformerElements.attributes(action);
        accessTransformer.attributes(action);
        accessTransformer.extendsFrom(new Configuration[]{accessTransformerApi});
        accessTransformerElements.extendsFrom(new Configuration[]{accessTransformerApi});
        AdhocComponentWithVariants java = (AdhocComponentWithVariants)project.getComponents().getByName("java");
        Runnable enable = () -> java.addVariantsFromConfiguration(accessTransformerElements, variant -> {});
        accessTransformerElements.getAllDependencies().configureEach(dep -> enable.run());
        accessTransformerElements.getArtifacts().configureEach(artifact -> enable.run());
        accessTransformersExtension.getFiles().from(new Object[]{accessTransformer});
    }

    private void applyAfterEvaluate(Project project) {
        NamedDomainObjectContainer runs = (NamedDomainObjectContainer)project.getExtensions().getByName("runs");
        runs.forEach(run -> {
            if (run instanceof RunImpl) {
                run.configure();
                if (((Boolean)run.getConfigureFromDependencies().get()).booleanValue()) {
                    RunImpl runImpl = (RunImpl)run;
                    HashMap<String, CommonRuntimeDefinition> definitionSet = new HashMap<String, CommonRuntimeDefinition>();
                    ((List)runImpl.getModSources().get()).forEach(sourceSet -> {
                        try {
                            Optional<CommonRuntimeDefinition<?>> definition = TaskDependencyUtils.findRuntimeDefinition(sourceSet);
                            if (definition.isPresent()) {
                                CommonRuntimeDefinition<?> runtimeDefinition = definition.get();
                                if (!definitionSet.containsKey(runtimeDefinition.getSpecification().getIdentifier())) {
                                    definitionSet.put(runtimeDefinition.getSpecification().getIdentifier(), runtimeDefinition);
                                } else if (SourceSetUtils.getProject(sourceSet) == project) {
                                    definitionSet.put(runtimeDefinition.getSpecification().getIdentifier(), runtimeDefinition);
                                }
                            }
                        }
                        catch (MultipleDefinitionsFoundException e) {
                            throw new RuntimeException("Failed to configure run: " + run.getName() + " there are multiple runtime definitions found for the source set: " + sourceSet.getName(), e);
                        }
                    });
                    definitionSet.forEach((identifier, definition) -> definition.configureRun(runImpl));
                }
            }
        });
        IdeRunIntegrationManager.getInstance().apply(project);
    }
}

