/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.stream.Collectors;
import net.neoforged.gradle.common.dependency.JarJarArtifacts;
import net.neoforged.gradle.common.dependency.ResolvedJarJarArtifact;
import net.neoforged.gradle.common.manifest.DefaultInheritManifest;
import net.neoforged.gradle.common.manifest.InheritManifest;
import net.neoforged.gradle.dsl.common.dependency.DependencyFilter;
import net.neoforged.gradle.dsl.common.dependency.DependencyVersionInformationHandler;
import net.neoforged.jarjar.metadata.Metadata;
import net.neoforged.jarjar.metadata.MetadataIOHandler;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.Jar;

public abstract class JarJar
extends Jar {
    private final CopySpec jarJarCopySpec = this.getMainSpec().addChild();

    @Nested
    public abstract JarJarArtifacts getJarJarArtifacts();

    public InheritManifest getManifest() {
        return (InheritManifest)super.getManifest();
    }

    public JarJar() {
        this.jarJarCopySpec.into((Object)"META-INF/jarjar");
        this.setDuplicatesStrategy(DuplicatesStrategy.EXCLUDE);
        this.setManifest(new DefaultInheritManifest((FileResolver)this.getServices().get(FileResolver.class)));
    }

    @Nested
    public DependencyFilter getDependencyFilter() {
        return this.getJarJarArtifacts().getDependencyFilter();
    }

    @Nested
    public DependencyVersionInformationHandler getDependencyVersionInformationHandler() {
        return this.getJarJarArtifacts().getDependencyVersionInformationHandler();
    }

    public JarJar dependencies(Action<DependencyFilter> c) {
        c.execute((Object)this.getDependencyFilter());
        return this;
    }

    public JarJar versionInformation(Action<DependencyVersionInformationHandler> c) {
        c.execute((Object)this.getDependencyVersionInformationHandler());
        return this;
    }

    @TaskAction
    protected void copy() {
        List includedJars = (List)this.getJarJarArtifacts().getResolvedArtifacts().get();
        this.jarJarCopySpec.from(new Object[]{includedJars.stream().map(ResolvedJarJarArtifact::getFile).collect(Collectors.toList())});
        if (!this.writeMetadata(includedJars).jars().isEmpty()) {
            this.jarJarCopySpec.from(new Object[]{this.getJarJarMetadataPath().toFile()});
        }
        super.copy();
    }

    private Metadata writeMetadata(List<ResolvedJarJarArtifact> includedJars) {
        Path metadataPath = this.getJarJarMetadataPath();
        Metadata metadata = this.createMetadata(includedJars);
        if (!metadata.jars().isEmpty()) {
            try {
                metadataPath.toFile().getParentFile().mkdirs();
                Files.deleteIfExists(metadataPath);
                Files.write(metadataPath, (Iterable<? extends CharSequence>)MetadataIOHandler.toLines((Metadata)metadata), StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write JarJar dependency metadata to disk.", e);
            }
        }
        return metadata;
    }

    public void configuration(Configuration jarJarConfiguration) {
        this.getJarJarArtifacts().configuration(jarJarConfiguration);
        this.dependsOn(new Object[]{jarJarConfiguration});
    }

    private Path getJarJarMetadataPath() {
        return this.getTemporaryDir().toPath().resolve("metadata.json");
    }

    private Metadata createMetadata(List<ResolvedJarJarArtifact> jars) {
        return new Metadata(jars.stream().map(ResolvedJarJarArtifact::createContainerMetadata).collect(Collectors.toList()));
    }
}

