/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.runs.run;

import java.util.Map;
import javax.inject.Inject;
import net.neoforged.gradle.dsl.common.runs.run.DependencyHandler;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;

public abstract class DependencyHandlerImpl
implements DependencyHandler {
    private final Project project;
    private final Configuration configuration;

    @Inject
    public DependencyHandlerImpl(Project project) {
        this.project = project;
        this.configuration = project.getConfigurations().detachedConfiguration(new Dependency[0]);
        this.configuration.setCanBeResolved(true);
        this.configuration.setCanBeConsumed(false);
        this.configuration.setTransitive(false);
    }

    public Project getProject() {
        return this.project;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Dependency runtime(Object dependencyNotation) {
        if (dependencyNotation instanceof Configuration) {
            this.configuration.extendsFrom(new Configuration[]{(Configuration)dependencyNotation});
            return null;
        }
        Dependency dependency = this.project.getDependencies().create(dependencyNotation);
        this.configuration.getDependencies().add((Object)dependency);
        return dependency;
    }

    public Dependency runtime(Object dependencyNotation, Action<Dependency> configureClosure) {
        if (dependencyNotation instanceof Configuration) {
            if (configureClosure != null) {
                throw new GradleException("Cannot add a Configuration with a configuration closure.");
            }
            this.configuration.extendsFrom(new Configuration[]{(Configuration)dependencyNotation});
            return null;
        }
        Dependency dependency = this.project.getDependencies().create(dependencyNotation);
        configureClosure.execute((Object)dependency);
        this.configuration.getDependencies().add((Object)dependency);
        return dependency;
    }

    public Dependency create(Object dependencyNotation) {
        Dependency dependency = this.project.getDependencies().create(dependencyNotation);
        this.configuration.getDependencies().add((Object)dependency);
        return dependency;
    }

    public Dependency create(Object dependencyNotation, Action<Dependency> configureClosure) {
        Dependency dependency = this.project.getDependencies().create(dependencyNotation);
        configureClosure.execute((Object)dependency);
        return dependency;
    }

    public Dependency module(Object notation) {
        return this.project.getDependencies().module(notation);
    }

    public Dependency module(Object notation, Action<Dependency> configureClosure) {
        Dependency dependency = this.project.getDependencies().module(notation);
        configureClosure.execute((Object)dependency);
        return dependency;
    }

    public Dependency project(Map<String, ?> notation) {
        Dependency dependency = this.project.getDependencies().project(notation);
        return dependency;
    }
}

