/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions.repository;

import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.neoforged.gradle.dsl.common.extensions.repository.RepositoryEntry;
import net.neoforged.gradle.dsl.common.extensions.repository.RepositoryReference;
import net.neoforged.gradle.util.IndentingXmlStreamWriter;

public final class IvyModuleWriter
implements AutoCloseable {
    private static final String XSI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String IVY = "http://ant.apache.org/ivy/schemas/ivy.xsd";
    private static final String VANILLAGRADLE = "https://minecraftforge.net/neogradle/ivy-extra";
    private static final XMLOutputFactory OUTPUT_FACTORY = XMLOutputFactory.newInstance();
    private static final String INDENT = "  ";
    private final boolean managedOutput;
    private final Writer output;
    private final XMLStreamWriter writer;

    public IvyModuleWriter(Writer output) throws XMLStreamException {
        this.managedOutput = false;
        this.output = output;
        this.writer = new IndentingXmlStreamWriter(OUTPUT_FACTORY.createXMLStreamWriter(output), INDENT);
    }

    public IvyModuleWriter(Path target) throws IOException, XMLStreamException {
        this.managedOutput = true;
        this.output = Files.newBufferedWriter(target, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        this.writer = new IndentingXmlStreamWriter(OUTPUT_FACTORY.createXMLStreamWriter(this.output), INDENT);
    }

    public void write(RepositoryEntry<?, ?> descriptor) throws XMLStreamException {
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.writer.writeStartElement("ivy-module");
        this.writer.writeNamespace("xsi", XSI);
        this.writer.writeNamespace("NeoGradle", VANILLAGRADLE);
        this.writer.writeAttribute(XSI, "noNamespaceSchemaLocation", IVY);
        this.writer.writeAttribute("version", "2.0");
        this.writeInfo(descriptor);
        this.writeDependencies(descriptor.getDependencies());
        this.writer.writeEndElement();
        this.writer.writeEndDocument();
    }

    private void writeInfo(RepositoryEntry<?, ?> entry) throws XMLStreamException {
        this.writer.writeStartElement("info");
        this.writer.writeAttribute("organisation", entry.getFullGroup());
        this.writer.writeAttribute("module", entry.getName());
        this.writer.writeAttribute("revision", entry.getVersion());
        this.writer.writeAttribute("status", "release");
        this.writer.writeEmptyElement("license");
        this.writer.writeAttribute("name", "Minecraft EULA");
        this.writer.writeAttribute("url", "https://www.minecraft.net/en-us/eula");
        this.writer.writeEndElement();
    }

    private void writeDependencies(Collection<? extends RepositoryReference> dependencies) throws XMLStreamException {
        this.writer.writeStartElement("dependencies");
        for (RepositoryReference repositoryReference : dependencies) {
            this.writeDependency(repositoryReference);
        }
        this.writer.writeEndElement();
    }

    private void writeDependency(RepositoryReference dep) throws XMLStreamException {
        boolean hasClassifier;
        boolean bl = hasClassifier = dep.getClassifier() != null;
        if (hasClassifier) {
            this.writer.writeStartElement("dependency");
        } else {
            this.writer.writeEmptyElement("dependency");
        }
        if (dep instanceof RepositoryEntry) {
            RepositoryEntry entry = (RepositoryEntry)dep;
            this.writer.writeAttribute("org", entry.getFullGroup());
        } else {
            this.writer.writeAttribute("org", dep.getGroup());
        }
        this.writer.writeAttribute("name", dep.getName());
        this.writer.writeAttribute("rev", dep.getVersion());
        this.writer.writeAttribute("transitive", "false");
        if (hasClassifier) {
            this.writer.writeEmptyElement("artifact");
            this.writer.writeAttribute("name", dep.getName());
            this.writer.writeAttribute("classifier", dep.getClassifier());
            this.writer.writeAttribute("ext", "jar");
            this.writer.writeEndElement();
        }
    }

    @Override
    public void close() throws IOException, XMLStreamException {
        this.writer.close();
        if (this.managedOutput) {
            this.output.close();
        }
    }
}

