/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions;

import groovyjarjarantlr4.v4.runtime.misc.NotNull;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.inject.Inject;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.dsl.common.extensions.ArtifactDownloader;
import net.neoforged.gradle.dsl.common.util.ConfigurationUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.provider.Provider;

public abstract class ArtifactDownloaderExtension
implements ConfigurableDSLElement<ArtifactDownloader>,
ArtifactDownloader {
    private final Project project;

    @Inject
    public ArtifactDownloaderExtension(Project project) {
        this.project = project;
    }

    public Project getProject() {
        return this.project;
    }

    @NotNull
    public Provider<String> version(String notation) {
        return this.project.provider(() -> {
            Configuration dummyConfiguration = ConfigurationUtils.temporaryConfiguration((Project)this.project, (Dependency[])new Dependency[]{this.project.getDependencies().create((Object)notation)});
            ResolvedConfiguration resolvedConfiguration = dummyConfiguration.getResolvedConfiguration();
            return ((ResolvedArtifact)resolvedConfiguration.getResolvedArtifacts().iterator().next()).getModuleVersion().getId().getVersion();
        });
    }

    @NotNull
    public Provider<File> file(String notation) {
        return this.project.provider(() -> {
            LinkedHashMap repositories = new LinkedHashMap(this.project.getRepositories().getAsMap());
            this.project.getRepositories().clear();
            try {
                for (ArtifactRepository repository : repositories.values()) {
                    this.project.getRepositories().add(repository);
                    Configuration dummyConfiguration = ConfigurationUtils.temporaryConfiguration((Project)this.project, (Dependency[])new Dependency[]{this.project.getDependencies().create((Object)notation)});
                    ResolvedConfiguration resolvedConfiguration = dummyConfiguration.getResolvedConfiguration();
                    Set result = resolvedConfiguration.getLenientConfiguration().getFiles();
                    if (result.size() < 1) continue;
                    File file = (File)result.iterator().next();
                    return file;
                }
            }
            finally {
                this.project.getRepositories().addAll(repositories.values());
            }
            throw new RuntimeException("Could not find artifact " + notation);
        });
    }
}

