/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.dependency;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.neoforged.jarjar.metadata.ContainedJarIdentifier;
import net.neoforged.jarjar.metadata.ContainedJarMetadata;
import net.neoforged.jarjar.metadata.ContainedVersion;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

public class ResolvedJarJarArtifact {
    private final File file;
    private final String version;
    private final String versionRange;
    private final String group;
    private final String artifact;

    public ResolvedJarJarArtifact(File file, String version, String versionRange, String group, String artifact) {
        this.file = file;
        this.version = version;
        this.versionRange = versionRange;
        this.group = group;
        this.artifact = artifact;
    }

    public ContainedJarIdentifier createContainedJarIdentifier() {
        return new ContainedJarIdentifier(this.group, this.artifact);
    }

    public ContainedVersion createContainedVersion() {
        try {
            return new ContainedVersion(VersionRange.createFromVersionSpec((String)this.versionRange), (ArtifactVersion)new DefaultArtifactVersion(this.version));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    public ContainedJarMetadata createContainerMetadata() {
        return new ContainedJarMetadata(this.createContainedJarIdentifier(), this.createContainedVersion(), "META-INF/jarjar/" + this.file.getName(), ResolvedJarJarArtifact.isObfuscated(this.file));
    }

    @InputFile
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public File getFile() {
        return this.file;
    }

    @Input
    public String getVersion() {
        return this.version;
    }

    @Input
    public String getVersionRange() {
        return this.versionRange;
    }

    @Input
    public String getGroup() {
        return this.group;
    }

    @Input
    public String getArtifact() {
        return this.artifact;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isObfuscated(File dependency) {
        try (JarFile jarFile = new JarFile(dependency);){
            Manifest manifest = jarFile.getManifest();
            boolean bl = manifest.getMainAttributes().containsKey("Obfuscated-By");
            return bl;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read jar file for dependency", e);
        }
    }
}

