/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.neoforged.gradle.common.caching.CentralCacheService;
import net.neoforged.gradle.common.dependency.ExtraJarDependencyManager;
import net.neoforged.gradle.common.extensions.AccessTransformersExtension;
import net.neoforged.gradle.common.extensions.ArtifactDownloaderExtension;
import net.neoforged.gradle.common.extensions.ConfigurationDataExtension;
import net.neoforged.gradle.common.extensions.ExtensionManager;
import net.neoforged.gradle.common.extensions.IdeManagementExtension;
import net.neoforged.gradle.common.extensions.MappingsExtension;
import net.neoforged.gradle.common.extensions.MinecraftArtifactCacheExtension;
import net.neoforged.gradle.common.extensions.MinecraftExtension;
import net.neoforged.gradle.common.extensions.ProjectEvaluationExtension;
import net.neoforged.gradle.common.extensions.ProjectHolderExtension;
import net.neoforged.gradle.common.extensions.dependency.creation.ProjectBasedDependencyCreator;
import net.neoforged.gradle.common.extensions.dependency.replacement.DependencyReplacementsExtension;
import net.neoforged.gradle.common.extensions.repository.IvyDummyRepositoryExtension;
import net.neoforged.gradle.common.extensions.subsystems.SubsystemsExtension;
import net.neoforged.gradle.common.runs.ide.IdeRunIntegrationManager;
import net.neoforged.gradle.common.runs.run.RunImpl;
import net.neoforged.gradle.common.runtime.definition.CommonRuntimeDefinition;
import net.neoforged.gradle.common.runtime.extensions.RuntimesExtension;
import net.neoforged.gradle.common.runtime.naming.OfficialNamingChannelConfigurator;
import net.neoforged.gradle.common.tasks.DisplayMappingsLicenseTask;
import net.neoforged.gradle.common.util.TaskDependencyUtils;
import net.neoforged.gradle.common.util.exceptions.MultipleDefinitionsFoundException;
import net.neoforged.gradle.common.util.run.RunsUtil;
import net.neoforged.gradle.dsl.common.extensions.AccessTransformers;
import net.neoforged.gradle.dsl.common.extensions.ArtifactDownloader;
import net.neoforged.gradle.dsl.common.extensions.ConfigurationData;
import net.neoforged.gradle.dsl.common.extensions.Mappings;
import net.neoforged.gradle.dsl.common.extensions.Minecraft;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import net.neoforged.gradle.dsl.common.extensions.ProjectHolder;
import net.neoforged.gradle.dsl.common.extensions.RunnableSourceSet;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.repository.Repository;
import net.neoforged.gradle.dsl.common.extensions.subsystems.Subsystems;
import net.neoforged.gradle.dsl.common.runs.run.Run;
import net.neoforged.gradle.dsl.common.runs.type.RunType;
import net.neoforged.gradle.dsl.common.runtime.naming.NamingChannel;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.Delete;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.jetbrains.gradle.ext.IdeaExtPlugin;

public class CommonProjectPlugin
implements Plugin<Project> {
    public static final String ASSETS_SERVICE = "ng_assets";
    public static final String LIBRARIES_SERVICE = "ng_libraries";

    public void apply(Project project) {
        project.getExtensions().create("evaluation", ProjectEvaluationExtension.class, new Object[]{project});
        project.getPluginManager().apply(JavaPlugin.class);
        CentralCacheService.register(project, ASSETS_SERVICE);
        CentralCacheService.register(project, LIBRARIES_SERVICE);
        project.getPluginManager().apply(IdeaPlugin.class);
        project.getRootProject().getPluginManager().apply(IdeaExtPlugin.class);
        project.getPluginManager().apply(IdeaExtPlugin.class);
        project.getPluginManager().apply(EclipsePlugin.class);
        project.getExtensions().create("allRuntimes", RuntimesExtension.class, new Object[0]);
        project.getExtensions().create(IdeManagementExtension.class, "ideManager", IdeManagementExtension.class, new Object[]{project});
        project.getExtensions().create(ArtifactDownloader.class, "artifactDownloader", ArtifactDownloaderExtension.class, new Object[]{project});
        project.getExtensions().create(Repository.class, "ivyDummyRepository", IvyDummyRepositoryExtension.class, new Object[]{project});
        project.getExtensions().create(MinecraftArtifactCache.class, "minecraftArtifactCache", MinecraftArtifactCacheExtension.class, new Object[]{project});
        project.getExtensions().create(DependencyReplacement.class, "dependencyReplacements", DependencyReplacementsExtension.class, new Object[]{project, project.getObjects().newInstance(ProjectBasedDependencyCreator.class, new Object[]{project})});
        project.getExtensions().create(AccessTransformers.class, "accessTransformers", AccessTransformersExtension.class, new Object[]{project});
        project.getExtensions().create("extensionManager", ExtensionManager.class, new Object[]{project});
        project.getExtensions().create("clientExtraJarDependencyManager", ExtraJarDependencyManager.class, new Object[]{project});
        ConfigurationData configurationData = (ConfigurationData)project.getExtensions().create(ConfigurationData.class, "configurationData", ConfigurationDataExtension.class, new Object[]{project});
        ExtensionManager extensionManager = (ExtensionManager)project.getExtensions().getByType(ExtensionManager.class);
        extensionManager.registerExtension("minecraft", Minecraft.class, p -> (MinecraftExtension)p.getObjects().newInstance(MinecraftExtension.class, new Object[]{p}));
        extensionManager.registerExtension("mappings", Mappings.class, p -> (MappingsExtension)p.getObjects().newInstance(MappingsExtension.class, new Object[]{p}));
        extensionManager.registerExtension("subsystems", Subsystems.class, p -> (SubsystemsExtension)p.getObjects().newInstance(SubsystemsExtension.class, new Object[]{p}));
        OfficialNamingChannelConfigurator.getInstance().configure(project);
        project.getTasks().register("handleNamingLicense", DisplayMappingsLicenseTask.class, task -> task.getLicense().set(project.provider(() -> {
            Mappings mappings = (Mappings)project.getExtensions().getByType(Mappings.class);
            if (((Boolean)((NamingChannel)mappings.getChannel().get()).getHasAcceptedLicense().get()).booleanValue()) {
                return null;
            }
            return (String)((NamingChannel)mappings.getChannel().get()).getLicenseText().get();
        })));
        project.getRepositories().maven(e -> {
            e.setUrl((Object)"https://libraries.minecraft.net/");
            e.metadataSources(MavenArtifactRepository.MetadataSources::artifact);
        });
        project.afterEvaluate(this::applyAfterEvaluate);
        ((SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class)).configureEach(sourceSet -> {
            sourceSet.getExtensions().create(ProjectHolder.class, "projectHolder", ProjectHolderExtension.class, new Object[]{project});
            sourceSet.getExtensions().create("runs", RunnableSourceSet.class, new Object[]{project});
            sourceSet.getExtensions().add("runtimeDefinition", (Object)project.getObjects().property(CommonRuntimeDefinition.class));
        });
        project.getExtensions().add("runTypes", (Object)project.getObjects().domainObjectContainer(RunType.class, name -> (RunType)project.getObjects().newInstance(RunType.class, new Object[]{name})));
        project.getExtensions().add("runs", (Object)project.getObjects().domainObjectContainer(Run.class, name -> RunsUtil.create(project, name)));
        IdeRunIntegrationManager.getInstance().setup(project);
        project.getTasks().named("clean", Delete.class, delete -> delete.delete(new Object[]{configurationData.getLocation()}));
    }

    private void applyAfterEvaluate(Project project) {
        DependencyReplacement dependencyReplacementExtension;
        RuntimesExtension runtimesExtension = (RuntimesExtension)project.getExtensions().getByType(RuntimesExtension.class);
        runtimesExtension.bakeDefinitions();
        runtimesExtension.bakeDelegateDefinitions();
        Repository repositoryExtension = (Repository)project.getExtensions().getByType(Repository.class);
        if (repositoryExtension instanceof IvyDummyRepositoryExtension) {
            IvyDummyRepositoryExtension ivyDummyRepositoryExtension = (IvyDummyRepositoryExtension)repositoryExtension;
            ivyDummyRepositoryExtension.onPostDefinitionBake(project);
        }
        if ((dependencyReplacementExtension = (DependencyReplacement)project.getExtensions().getByType(DependencyReplacement.class)) instanceof DependencyReplacementsExtension) {
            DependencyReplacementsExtension dependencyReplacementsExtension = (DependencyReplacementsExtension)dependencyReplacementExtension;
            dependencyReplacementsExtension.onPostDefinitionBakes(project);
        }
        project.getExtensions().configure("runs", runs -> runs.forEach(run -> {
            if (run instanceof RunImpl) {
                run.configure();
                if (((Boolean)run.getConfigureFromDependencies().get()).booleanValue()) {
                    RunImpl runImpl = (RunImpl)run;
                    HashSet definitionSet = new HashSet();
                    ((List)runImpl.getModSources().get()).forEach(sourceSet -> {
                        try {
                            Optional<CommonRuntimeDefinition<?>> definition = TaskDependencyUtils.findRuntimeDefinition(project, sourceSet);
                            definition.ifPresent(definitionSet::add);
                        }
                        catch (MultipleDefinitionsFoundException e) {
                            throw new RuntimeException("Failed to configure run: " + run.getName() + " there are multiple runtime definitions found for the source set: " + sourceSet.getName(), e);
                        }
                    });
                    definitionSet.forEach(definition -> definition.configureRun(runImpl));
                }
            }
        }));
        IdeRunIntegrationManager.getInstance().apply(project);
    }
}

