/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.gradle.dsl.common.util.Artifact;
import org.jetbrains.annotations.Nullable;

public class VersionJson
implements Serializable {
    protected static final Gson GSON = new GsonBuilder().registerTypeAdapter(Argument.class, (Object)new Argument.Deserializer()).setPrettyPrinting().create();
    private String id;
    @javax.annotation.Nullable
    private Arguments arguments;
    private AssetIndex assetIndex;
    private String assets;
    @javax.annotation.Nullable
    private Map<String, Download> downloads;
    private Library[] libraries;
    private List<LibraryDownload> _natives = null;
    private List<Library> _libraries = null;
    private String mainClass;
    private String type;

    public static VersionJson get(Path path) throws IOException {
        return VersionJson.get(path.toFile());
    }

    public static VersionJson get(@javax.annotation.Nullable File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("VersionJson File can not be null!");
        }
        try (FileInputStream in = new FileInputStream(file);){
            VersionJson versionJson = VersionJson.get(in);
            return versionJson;
        }
    }

    public static VersionJson get(InputStream stream) {
        return (VersionJson)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), VersionJson.class);
    }

    public List<LibraryDownload> getNatives() {
        if (this._natives == null) {
            HashMap<String, Entry> natives = new HashMap<String, Entry>();
            OS os = OS.getCurrent();
            for (Library lib : this.libraries) {
                LibraryDownload l;
                if (!lib.isAllowed()) continue;
                String key = lib.getArtifact().getGroup() + ':' + lib.getArtifact().getName() + ':' + lib.getArtifact().getVersion();
                if (lib.getNatives() == null || lib.getDownloads().getClassifiers() == null || !lib.getNatives().containsKey(os.getName()) || (l = lib.getDownloads().getClassifiers().get(lib.getNatives().get(os.getName()))) == null) continue;
                natives.put(key, new Entry(2, l));
            }
            this._natives = natives.values().stream().map(Entry::download).collect(Collectors.toList());
        }
        return this._natives;
    }

    public List<String> getPlatformJvmArgs() {
        if (this.arguments == null || this.arguments.jvm == null) {
            return Collections.emptyList();
        }
        return Stream.of(this.arguments.jvm).filter(arg -> arg.getRules() != null && arg.isAllowed()).flatMap(arg -> arg.value.stream()).map(s -> {
            if (s.indexOf(32) != -1) {
                return "\"" + s + "\"";
            }
            return s;
        }).collect(Collectors.toList());
    }

    public String getId() {
        return this.id;
    }

    public Arguments getArguments() {
        return this.arguments == null ? new Arguments() : this.arguments;
    }

    public AssetIndex getAssetIndex() {
        return this.assetIndex;
    }

    public String getAssets() {
        return this.assets;
    }

    @javax.annotation.Nullable
    public Map<String, Download> getDownloads() {
        return this.downloads;
    }

    public List<Library> getLibraries() {
        if (this._libraries == null) {
            this._libraries = new ArrayList<Library>();
            for (Library lib : this.libraries) {
                if (!lib.isAllowed()) continue;
                this._libraries.add(lib);
            }
            this._libraries = ImmutableList.copyOf(this._libraries);
        }
        return this._libraries;
    }

    public String getType() {
        return this.type;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    private static final class Entry
    implements Serializable {
        private final int priority;
        private final LibraryDownload download;

        Entry(int priority, LibraryDownload download) {
            this.priority = priority;
            this.download = download;
        }

        public int priority() {
            return this.priority;
        }

        public LibraryDownload download() {
            return this.download;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Entry that = (Entry)obj;
            return this.priority == that.priority && Objects.equals(this.download, that.download);
        }

        public int hashCode() {
            return Objects.hash(this.priority, this.download);
        }

        public String toString() {
            return "Entry[priority=" + this.priority + ", download=" + this.download + ']';
        }
    }

    public static enum OS {
        WINDOWS("windows", "win"),
        LINUX("linux", "linux", "unix"),
        OSX("osx", "mac"),
        UNKNOWN("unknown", new String[0]);

        private final String name;
        private final String[] keys;

        private OS(String name, String ... keys) {
            this.name = name;
            this.keys = keys;
        }

        public String getName() {
            return this.name;
        }

        public static OS getCurrent() {
            String prop = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
            for (OS os : OS.values()) {
                for (String key : os.keys) {
                    if (!prop.contains(key)) continue;
                    return os;
                }
            }
            return UNKNOWN;
        }
    }

    public static class Library
    extends RuledObject
    implements Serializable {
        private String name;
        private Map<String, String> natives;
        private Downloads downloads;
        private Artifact _artifact;

        public Artifact getArtifact() {
            if (this._artifact == null) {
                this._artifact = Artifact.from((String)this.getName());
            }
            return this._artifact;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, String> getNatives() {
            return this.natives;
        }

        public Downloads getDownloads() {
            return this.downloads;
        }
    }

    public static class Downloads
    implements Serializable {
        @javax.annotation.Nullable
        private Map<String, LibraryDownload> classifiers;
        @javax.annotation.Nullable
        private LibraryDownload artifact;

        @javax.annotation.Nullable
        public Map<String, LibraryDownload> getClassifiers() {
            return this.classifiers;
        }

        @javax.annotation.Nullable
        public LibraryDownload getArtifact() {
            return this.artifact;
        }
    }

    public static class LibraryDownload
    extends Download
    implements Serializable {
        private String path;

        public String getPath() {
            return this.path;
        }
    }

    public static class Download
    implements Serializable {
        private String sha1;
        private int size;
        private URL url;

        public String getSha1() {
            return this.sha1;
        }

        public int getSize() {
            return this.size;
        }

        public URL getUrl() {
            return this.url;
        }
    }

    public static class AssetIndex
    extends Download
    implements Serializable {
        private String id;
        private int totalSize;

        public String getId() {
            return this.id;
        }

        public int getTotalSize() {
            return this.totalSize;
        }
    }

    public static class OsCondition
    implements Serializable {
        @javax.annotation.Nullable
        private String name;
        @javax.annotation.Nullable
        private String version;
        @javax.annotation.Nullable
        private String arch;

        public boolean nameMatches() {
            return this.getName() == null || OS.getCurrent().getName().equals(this.getName());
        }

        public boolean versionMatches() {
            return this.getVersion() == null || Pattern.compile(this.getVersion()).matcher(System.getProperty("os.version")).find();
        }

        public boolean archMatches() {
            return this.getArch() == null || Pattern.compile(this.getArch()).matcher(System.getProperty("os.arch")).find();
        }

        public boolean platformMatches() {
            return this.nameMatches() && this.versionMatches() && this.archMatches();
        }

        @javax.annotation.Nullable
        public String getName() {
            return this.name;
        }

        @javax.annotation.Nullable
        public String getVersion() {
            return this.version;
        }

        @javax.annotation.Nullable
        public String getArch() {
            return this.arch;
        }
    }

    public static class Rule
    implements Serializable {
        private String action;
        @Nullable
        private OsCondition os;

        public boolean allowsAction() {
            return (this.getOs() == null || this.getOs().platformMatches()) == this.getAction().equals("allow");
        }

        public String getAction() {
            return this.action;
        }

        @Nullable
        public OsCondition getOs() {
            return this.os;
        }
    }

    public static class RuledObject
    implements Serializable {
        @javax.annotation.Nullable
        protected Rule[] rules;

        public boolean isAllowed() {
            if (this.getRules() != null) {
                for (Rule rule : this.getRules()) {
                    if (rule.allowsAction()) continue;
                    return false;
                }
            }
            return true;
        }

        @javax.annotation.Nullable
        public Rule[] getRules() {
            return this.rules;
        }
    }

    public static class Argument
    extends RuledObject
    implements Serializable {
        public List<String> value;

        public Argument(@javax.annotation.Nullable Rule[] rules, List<String> value) {
            this.rules = rules;
            this.value = value;
        }

        public static class Deserializer
        implements JsonDeserializer<Argument> {
            public Argument deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (json.isJsonPrimitive()) {
                    return new Argument(null, Collections.singletonList(json.getAsString()));
                }
                JsonObject obj = json.getAsJsonObject();
                if (!obj.has("rules") || !obj.has("value")) {
                    throw new JsonParseException("Error parsing arguments in version json. File is corrupt or its format has changed.");
                }
                JsonElement val = obj.get("value");
                Rule[] rules = (Rule[])GSON.fromJson(obj.get("rules"), Rule[].class);
                List value = val.isJsonPrimitive() ? Collections.singletonList(val.getAsString()) : (List)GSON.fromJson(val, List.class);
                return new Argument(rules, value);
            }
        }
    }

    public static class Arguments
    implements Serializable {
        private Argument[] game;
        @javax.annotation.Nullable
        private Argument[] jvm;

        public Argument[] getGame() {
            return this.game;
        }

        public Argument[] getJvm() {
            return this.jvm == null ? new Argument[]{} : this.jvm;
        }
    }
}

