/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MappingUtils {
    private MappingUtils() {
        throw new IllegalStateException("MappingUtils is a utility class!");
    }

    @NotNull
    public static String getVersionOrMinecraftVersion(@NotNull Map<String, String> mappingVersionData) {
        String mappingVersion = mappingVersionData.get("version");
        if (mappingVersion == null) {
            String minecraftVersion = mappingVersionData.get("minecraft");
            if (minecraftVersion == null) {
                throw new IllegalStateException("Mapping version data does not contain a version or a minecraft version!");
            }
            return minecraftVersion;
        }
        return mappingVersion;
    }

    @NotNull
    public static String getMinecraftVersion(@NotNull Map<String, String> mappingVersionData) {
        String minecraftVersion = mappingVersionData.get("minecraft");
        if (minecraftVersion == null) {
            throw new IllegalStateException("Mapping version data does not contain a version or a minecraft version!");
        }
        return minecraftVersion;
    }
}

