/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.util;

import java.io.File;
import java.util.Collection;
import java.util.function.Consumer;
import net.neoforged.gradle.common.runtime.tasks.AccessTransformer;
import net.neoforged.gradle.common.runtime.tasks.AccessTransformerFileGenerator;
import net.neoforged.gradle.dsl.common.runtime.definition.Definition;
import net.neoforged.gradle.dsl.common.runtime.spec.Specification;
import net.neoforged.gradle.dsl.common.runtime.tasks.Runtime;
import net.neoforged.gradle.dsl.common.tasks.specifications.OutputSpecification;
import net.neoforged.gradle.dsl.common.util.CommonRuntimeUtils;
import net.neoforged.gradle.util.StringCapitalizationUtils;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.TaskProvider;

public final class CommonRuntimeTaskUtils {
    private CommonRuntimeTaskUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: CommonRuntimeTaskUtils. This is a utility class");
    }

    public static TaskProvider<? extends AccessTransformer> createAccessTransformer(Definition<?> definition, String namePreFix, File workspaceDirectory, Consumer<TaskProvider<? extends Runtime>> dependentTaskConfigurationHandler, FileTree files, Collection<String> data) {
        TaskProvider generator;
        if (!data.isEmpty()) {
            generator = definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)(namePreFix + "AccessTransformerGenerator")), AccessTransformerFileGenerator.class, task -> {
                task.getOutput().set(new File(workspaceDirectory, "accesstransformers/" + namePreFix + "/_script-access-transformer.cfg"));
                task.getAdditionalTransformers().set((Iterable)data);
            });
            dependentTaskConfigurationHandler.accept((TaskProvider<? extends Runtime>)generator);
        } else {
            generator = null;
        }
        return definition.getSpecification().getProject().getTasks().register(CommonRuntimeUtils.buildTaskName((Specification)definition.getSpecification(), (String)String.format("apply%sAccessTransformer", StringCapitalizationUtils.capitalize((String)namePreFix))), AccessTransformer.class, task -> {
            task.getTransformers().from(new Object[]{files});
            if (generator != null) {
                task.getTransformers().from(new Object[]{generator.flatMap(OutputSpecification::getOutput)});
                task.dependsOn(new Object[]{generator});
            }
        });
    }
}

