/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.tasks;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import net.neoforged.gradle.common.util.FileDownloadingUtils;
import net.neoforged.gradle.common.util.SerializationUtils;
import net.neoforged.gradle.dsl.common.tasks.NeoGradleBase;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.tasks.WithWorkspace;
import net.neoforged.gradle.dsl.common.util.CacheFileSelector;
import net.neoforged.gradle.util.HashFunction;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="This is an abstract underlying task which provides defaults and systems for caching game artifacts.")
public abstract class FileCacheProviding
extends NeoGradleBase
implements WithOutput,
WithWorkspace {
    protected FileCacheProviding() {
        this.getFileCache().set(this.getSelector().map(selector -> this.getLayout().getProjectDirectory().dir(".gradle/caches/minecraft").dir(selector.getCacheDirectory())));
        this.getFileCache().finalizeValueOnRead();
        this.getIsOffline().set((Object)this.getProject().getGradle().getStartParameter().isOffline());
        this.getOutputFileName().set(this.getSelector().map(CacheFileSelector::getCacheFileName));
        this.getOutput().set(this.getFileCache().flatMap(cacheDir -> this.getOutputFileName().map(arg_0 -> ((Directory)cacheDir).file(arg_0))));
    }

    @Internal
    public abstract DirectoryProperty getFileCache();

    @Nested
    public abstract Property<CacheFileSelector> getSelector();

    @Optional
    @Input
    public abstract Property<Boolean> getIsOffline();

    protected void downloadJsonTo(String url) {
        File output = ((RegularFile)this.getOutput().get()).getAsFile();
        FileDownloadingUtils.DownloadInfo info = new FileDownloadingUtils.DownloadInfo(url, null, "json", null, null);
        boolean didWork = FileDownloadingUtils.downloadThrowing((Boolean)this.getIsOffline().get(), info, output);
        this.setDidWork(didWork);
    }

    protected void doDownloadVersionDownloadToCache(String artifact, String potentialError, File versionManifest) {
        JsonObject json = SerializationUtils.fromJson(versionManifest, JsonObject.class);
        JsonObject artifactInfo = json.getAsJsonObject("downloads").getAsJsonObject(artifact);
        String url = artifactInfo.get("url").getAsString();
        String hash = artifactInfo.get("sha1").getAsString();
        String version = json.getAsJsonObject().get("id").getAsString();
        FileDownloadingUtils.DownloadInfo info = new FileDownloadingUtils.DownloadInfo(url, hash, "jar", version, artifact);
        File output = ((RegularFile)this.getOutput().get()).getAsFile();
        try {
            String fileHash;
            if (output.exists() && (fileHash = HashFunction.SHA1.hash(output)).equals(hash)) {
                return;
            }
            FileDownloadingUtils.downloadTo((Boolean)this.getIsOffline().get(), info, output);
        }
        catch (IOException e) {
            throw new RuntimeException(potentialError, e);
        }
    }
}

