/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.extensions;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import net.minecraftforge.gdi.ConfigurableDSLElement;
import net.neoforged.gradle.common.tasks.MinecraftVersionManifestFileCacheProvider;
import net.neoforged.gradle.common.util.FileCacheUtils;
import net.neoforged.gradle.common.util.FileDownloadingUtils;
import net.neoforged.gradle.common.util.MinecraftArtifactType;
import net.neoforged.gradle.common.util.SerializationUtils;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import net.neoforged.gradle.dsl.common.tasks.WithOutput;
import net.neoforged.gradle.dsl.common.util.CacheFileSelector;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import net.neoforged.gradle.dsl.common.util.GameArtifact;
import net.neoforged.gradle.dsl.common.util.MinecraftVersionAndUrl;
import net.neoforged.gradle.util.HashFunction;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

public abstract class MinecraftArtifactCacheExtension
implements ConfigurableDSLElement<MinecraftArtifactCache>,
MinecraftArtifactCache {
    private final Project project;
    private final Map<CacheFileSelector, File> cacheFiles;
    private final Map<TaskKey, Map<GameArtifact, TaskProvider<? extends WithOutput>>> tasks = new ConcurrentHashMap<TaskKey, Map<GameArtifact, TaskProvider<? extends WithOutput>>>();

    @Inject
    public MinecraftArtifactCacheExtension(Project project) {
        this.project = project;
        this.cacheFiles = new ConcurrentHashMap<CacheFileSelector, File>();
        this.getCacheDirectory().fileProvider(project.provider(() -> new File(project.getGradle().getGradleUserHomeDir(), "caches/minecraft")));
        this.getCacheDirectory().finalizeValueOnRead();
    }

    public Project getProject() {
        return this.project;
    }

    public abstract DirectoryProperty getCacheDirectory();

    public final Map<CacheFileSelector, File> getCacheFiles() {
        return ImmutableMap.copyOf(this.cacheFiles);
    }

    public final Map<GameArtifact, File> cacheGameVersion(String gameVersion, DistributionType side) {
        MinecraftVersionAndUrl resolvedVersion = this.resolveVersion(gameVersion);
        EnumMap<GameArtifact, File> result = new EnumMap<GameArtifact, File>(GameArtifact.class);
        GameArtifact.VERSION_MANIFEST.doWhenRequired(side, () -> result.put(GameArtifact.VERSION_MANIFEST, this.cacheVersionManifest(resolvedVersion)));
        GameArtifact.CLIENT_JAR.doWhenRequired(side, () -> result.put(GameArtifact.CLIENT_JAR, this.cacheVersionArtifact(resolvedVersion, DistributionType.CLIENT)));
        GameArtifact.SERVER_JAR.doWhenRequired(side, () -> result.put(GameArtifact.SERVER_JAR, this.cacheVersionArtifact(resolvedVersion, DistributionType.SERVER)));
        GameArtifact.CLIENT_MAPPINGS.doWhenRequired(side, () -> result.put(GameArtifact.CLIENT_MAPPINGS, this.cacheVersionMappings(resolvedVersion, DistributionType.CLIENT)));
        GameArtifact.SERVER_MAPPINGS.doWhenRequired(side, () -> result.put(GameArtifact.SERVER_MAPPINGS, this.cacheVersionMappings(resolvedVersion, DistributionType.SERVER)));
        return result;
    }

    @NotNull
    public final Map<GameArtifact, TaskProvider<? extends WithOutput>> cacheGameVersionTasks(Project project, String gameVersion, DistributionType side) {
        MinecraftVersionAndUrl resolvedVersion = this.resolveVersion(gameVersion);
        TaskKey key = new TaskKey(project, resolvedVersion.getVersion(), side);
        return this.tasks.computeIfAbsent(key, k -> {
            EnumMap results = new EnumMap(GameArtifact.class);
            TaskProvider<MinecraftVersionManifestFileCacheProvider> manifest = FileCacheUtils.createVersionManifestFileCacheProvidingTask(project, resolvedVersion.getVersion());
            GameArtifact.VERSION_MANIFEST.doWhenRequired(side, () -> results.put(GameArtifact.VERSION_MANIFEST, manifest));
            GameArtifact.CLIENT_JAR.doWhenRequired(side, () -> results.put(GameArtifact.CLIENT_JAR, FileCacheUtils.createArtifactFileCacheProvidingTask(project, resolvedVersion.getVersion(), DistributionType.CLIENT, MinecraftArtifactType.EXECUTABLE, manifest, results.values())));
            GameArtifact.SERVER_JAR.doWhenRequired(side, () -> results.put(GameArtifact.SERVER_JAR, FileCacheUtils.createArtifactFileCacheProvidingTask(project, resolvedVersion.getVersion(), DistributionType.SERVER, MinecraftArtifactType.EXECUTABLE, manifest, results.values())));
            GameArtifact.CLIENT_MAPPINGS.doWhenRequired(side, () -> results.put(GameArtifact.CLIENT_MAPPINGS, FileCacheUtils.createArtifactFileCacheProvidingTask(project, resolvedVersion.getVersion(), DistributionType.CLIENT, MinecraftArtifactType.MAPPINGS, manifest, results.values())));
            GameArtifact.SERVER_MAPPINGS.doWhenRequired(side, () -> results.put(GameArtifact.SERVER_MAPPINGS, FileCacheUtils.createArtifactFileCacheProvidingTask(project, resolvedVersion.getVersion(), DistributionType.SERVER, MinecraftArtifactType.MAPPINGS, manifest, results.values())));
            return results;
        });
    }

    public final File cacheLauncherMetadata() {
        return this.cache("https://piston-meta.mojang.com/mc/game/version_manifest.json", CacheFileSelector.launcherMetadata());
    }

    public final File cacheVersionManifest(String gameVersion) {
        MinecraftVersionAndUrl resolvedVersion = this.resolveVersion(gameVersion);
        return this.cacheVersionManifest(resolvedVersion);
    }

    public final File cacheVersionManifest(MinecraftVersionAndUrl resolvedVersion) {
        CacheFileSelector cacheFileSelector = CacheFileSelector.forVersionJson((String)resolvedVersion.getVersion());
        return this.cacheFiles.computeIfAbsent(cacheFileSelector, selector -> this.downloadVersionManifestToCache(this.project, ((Directory)this.getCacheDirectory().get()).getAsFile(), resolvedVersion.getVersion()));
    }

    public final File cacheVersionArtifact(String gameVersion, DistributionType side) {
        MinecraftVersionAndUrl resolvedVersion = this.resolveVersion(gameVersion);
        CacheFileSelector cacheFileSelector = CacheFileSelector.forVersionJar((String)resolvedVersion.getVersion(), (String)side.getName());
        return this.cacheFiles.computeIfAbsent(cacheFileSelector, selector -> this.downloadVersionArtifactToCache(this.project, ((Directory)this.getCacheDirectory().get()).getAsFile(), resolvedVersion.getVersion(), side));
    }

    public final File cacheVersionArtifact(MinecraftVersionAndUrl resolvedVersion, DistributionType side) {
        CacheFileSelector cacheFileSelector = CacheFileSelector.forVersionJar((String)resolvedVersion.getVersion(), (String)side.getName());
        return this.cacheFiles.computeIfAbsent(cacheFileSelector, selector -> this.downloadVersionArtifactToCache(this.project, ((Directory)this.getCacheDirectory().get()).getAsFile(), resolvedVersion.getVersion(), side));
    }

    public final File cacheVersionMappings(@NotNull String gameVersion, DistributionType side) {
        MinecraftVersionAndUrl resolvedVersion = this.resolveVersion(gameVersion);
        CacheFileSelector cacheFileSelector = CacheFileSelector.forVersionMappings((String)resolvedVersion.getVersion(), (String)side.getName());
        return this.cacheFiles.computeIfAbsent(cacheFileSelector, selector -> this.downloadVersionMappingsToCache(this.project, ((Directory)this.getCacheDirectory().get()).getAsFile(), resolvedVersion.getVersion(), side));
    }

    public final File cacheVersionMappings(@NotNull MinecraftVersionAndUrl resolvedVersion, DistributionType side) {
        CacheFileSelector cacheFileSelector = CacheFileSelector.forVersionMappings((String)resolvedVersion.getVersion(), (String)side.getName());
        return this.cacheFiles.computeIfAbsent(cacheFileSelector, selector -> this.downloadVersionMappingsToCache(this.project, ((Directory)this.getCacheDirectory().get()).getAsFile(), resolvedVersion.getVersion(), side));
    }

    public final File cache(URL url, CacheFileSelector selector) {
        return this.cache(url.toString(), selector);
    }

    public final File cache(String url, CacheFileSelector selector) {
        return this.cacheFiles.computeIfAbsent(selector, cacheKey -> this.downloadJsonToCache(this.project, url, (File)this.getCacheDirectory().getAsFile().get(), selector));
    }

    private File downloadVersionManifestToCache(Project project, File cacheDirectory, String minecraftVersion) {
        File manifestFile = new File(new File(cacheDirectory, CacheFileSelector.launcherMetadata().getCacheDirectory()), CacheFileSelector.launcherMetadata().getCacheFileName());
        String url = null;
        JsonObject json = SerializationUtils.fromJson(manifestFile, JsonObject.class);
        for (JsonElement e : json.getAsJsonArray("versions")) {
            String v = e.getAsJsonObject().get("id").getAsString();
            if (!Objects.equals(minecraftVersion, "+") && !v.equals(minecraftVersion)) continue;
            url = e.getAsJsonObject().get("url").getAsString();
            break;
        }
        if (url == null) {
            throw new IllegalStateException("Could not find the correct version json for version: " + minecraftVersion);
        }
        return this.downloadJsonToCache(project, url, cacheDirectory, CacheFileSelector.forVersionJson((String)minecraftVersion));
    }

    private File downloadVersionArtifactToCache(Project project, File cacheDirectory, String minecraftVersion, DistributionType side) {
        MinecraftVersionAndUrl resolvedVersion = this.resolveVersion(minecraftVersion);
        return this.doDownloadVersionDownloadToCache(project, cacheDirectory, resolvedVersion.getVersion(), side.getName(), CacheFileSelector.forVersionJar((String)resolvedVersion.getVersion(), (String)side.getName()), String.format("Failed to download game artifact %s for %s", side.getName(), resolvedVersion.getVersion()));
    }

    private File downloadVersionMappingsToCache(Project project, File cacheDirectory, String minecraftVersion, DistributionType side) {
        MinecraftVersionAndUrl resolvedVersion = this.resolveVersion(minecraftVersion);
        return this.doDownloadVersionDownloadToCache(project, cacheDirectory, resolvedVersion.getVersion(), String.format("%s_mappings", side.getName()), CacheFileSelector.forVersionMappings((String)resolvedVersion.getVersion(), (String)side.getName()), String.format("Failed to download game mappings of %s for %s", side.getName(), resolvedVersion.getVersion()));
    }

    private File doDownloadVersionDownloadToCache(Project project, File cacheDirectory, String minecraftVersion, String artifact, CacheFileSelector cacheFileSelector, String potentialError) {
        MinecraftVersionAndUrl minecraftVersionAndUrl = this.resolveVersion(minecraftVersion);
        File versionManifestFile = this.cacheVersionManifest(minecraftVersionAndUrl);
        try {
            String fileHash;
            JsonObject json = SerializationUtils.fromJson(versionManifestFile, JsonObject.class);
            JsonObject artifactInfo = json.getAsJsonObject("downloads").getAsJsonObject(artifact);
            String url = artifactInfo.get("url").getAsString();
            String hash = artifactInfo.get("sha1").getAsString();
            String version = json.getAsJsonObject().get("id").getAsString();
            FileDownloadingUtils.DownloadInfo info = new FileDownloadingUtils.DownloadInfo(url, hash, "jar", version, artifact);
            File cacheFile = new File(new File(cacheDirectory, cacheFileSelector.getCacheDirectory()), cacheFileSelector.getCacheFileName());
            if (cacheFile.exists() && (fileHash = HashFunction.SHA1.hash(cacheFile)).equals(hash)) {
                return cacheFile;
            }
            FileDownloadingUtils.downloadTo(project.getGradle().getStartParameter().isOffline(), info, cacheFile);
            return cacheFile;
        }
        catch (IOException e) {
            throw new RuntimeException(potentialError, e);
        }
    }

    private File downloadJsonToCache(Project project, String url, File cacheDirectory, CacheFileSelector selector) {
        File cacheFile = new File(new File(cacheDirectory, selector.getCacheDirectory()), selector.getCacheFileName());
        this.downloadJsonTo(project, url, cacheFile);
        return cacheFile;
    }

    private void downloadJsonTo(Project project, String url, File file) {
        FileDownloadingUtils.downloadThrowing(project.getGradle().getStartParameter().isOffline(), new FileDownloadingUtils.DownloadInfo(url, null, "json", null, null), file);
    }

    public MinecraftVersionAndUrl resolveVersion(String gameVersion) {
        File launcherMetadata = this.cacheLauncherMetadata();
        JsonObject json = SerializationUtils.fromJson(launcherMetadata, JsonObject.class);
        for (JsonElement e : json.getAsJsonArray("versions")) {
            if (!gameVersion.equals("+") && !e.getAsJsonObject().get("id").getAsString().equals(gameVersion)) continue;
            return new MinecraftVersionAndUrl(e.getAsJsonObject().get("id").getAsString(), e.getAsJsonObject().get("url").getAsString());
        }
        throw new IllegalStateException("Could not find the correct version json.");
    }

    public Provider<MinecraftVersionAndUrl> resolveVersion(Provider<String> gameVersion) {
        return gameVersion.map(this::resolveVersion);
    }

    private static final class TaskKey {
        private final Project project;
        private final String gameVersion;
        private final DistributionType type;

        private TaskKey(Project project, String gameVersion, DistributionType type) {
            this.project = project;
            this.gameVersion = gameVersion;
            this.type = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaskKey taskKey = (TaskKey)o;
            return Objects.equals(this.project, taskKey.project) && Objects.equals(this.gameVersion, taskKey.gameVersion) && this.type == taskKey.type;
        }

        public int hashCode() {
            return Objects.hash(this.project, this.gameVersion, this.type);
        }
    }
}

