/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.gradle.common.dependency;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import net.neoforged.gradle.common.runtime.tasks.GenerateExtraJar;
import net.neoforged.gradle.dsl.common.extensions.MinecraftArtifactCache;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacement;
import net.neoforged.gradle.dsl.common.extensions.dependency.replacement.DependencyReplacementResult;
import net.neoforged.gradle.dsl.common.util.DistributionType;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExternalModuleDependency;
import org.gradle.api.tasks.TaskProvider;

public abstract class ExtraJarDependencyManager {
    private final Map<String, DependencyReplacementResult> replacements = Maps.newHashMap();

    public static String generateClientCoordinateFor(String version) {
        return "net.minecraft:client:" + version + ":client-extra";
    }

    public static String generateServerCoordinateFor(String version) {
        return "net.minecraft:client:" + version + ":client-extra";
    }

    public static String generateCoordinateFor(DistributionType type, String version) {
        return String.format("net.minecraft:%s:%s:%s-extra", type.getName().toLowerCase(), version, type.getName().toLowerCase());
    }

    @Inject
    public ExtraJarDependencyManager(Project project) {
        DependencyReplacement dependencyReplacementsExtension = (DependencyReplacement)project.getExtensions().getByType(DependencyReplacement.class);
        dependencyReplacementsExtension.getReplacementHandlers().register("extraJar", dependencyReplacementHandler -> dependencyReplacementHandler.getReplacer().set(context -> {
            if (this.isNotAMatchingDependency((Dependency)context.getDependency())) {
                return Optional.empty();
            }
            return Optional.of(this.generateReplacement(project, (Dependency)context.getDependency()));
        }));
    }

    private boolean isNotAMatchingDependency(Dependency dependencyToCheck) {
        if (dependencyToCheck instanceof ExternalModuleDependency) {
            ExternalModuleDependency externalModuleDependency = (ExternalModuleDependency)dependencyToCheck;
            return externalModuleDependency.getGroup() == null || !externalModuleDependency.getGroup().equals("net.minecraft") || !this.isSupportedSide(dependencyToCheck) || !this.hasMatchingArtifact(externalModuleDependency);
        }
        return true;
    }

    private boolean isSupportedSide(Dependency dependency) {
        return dependency.getName().equals("client") || dependency.getName().equals("server");
    }

    private boolean hasMatchingArtifact(ExternalModuleDependency externalModuleDependency) {
        if (externalModuleDependency.getVersion() == null) {
            return false;
        }
        if (externalModuleDependency.getArtifacts().size() != 1) {
            return false;
        }
        DependencyArtifact artifact = (DependencyArtifact)externalModuleDependency.getArtifacts().iterator().next();
        return Objects.equals(artifact.getClassifier(), "client-extra") || Objects.equals(artifact.getClassifier(), "server-extra");
    }

    private DependencyReplacementResult generateReplacement(Project project, Dependency dependency) {
        String minecraftVersion = dependency.getVersion();
        return this.replacements.computeIfAbsent(minecraftVersion, v -> {
            MinecraftArtifactCache minecraftArtifactCacheExtension = (MinecraftArtifactCache)project.getExtensions().getByType(MinecraftArtifactCache.class);
            TaskProvider extraJarTaskProvider = project.getTasks().register("create" + minecraftVersion + StringUtils.capitalize((String)dependency.getName()) + "ExtraJar", GenerateExtraJar.class, task -> {
                task.getOriginalJar().set(minecraftArtifactCacheExtension.cacheVersionArtifact(minecraftVersion, DistributionType.CLIENT));
                task.getOutput().set(project.getLayout().getBuildDirectory().dir("jars/extra/" + dependency.getName()).map(cacheDir -> cacheDir.dir(Objects.requireNonNull(minecraftVersion)).file(dependency.getName() + "-extra.jar")));
            });
            return new DependencyReplacementResult(project, name -> name, extraJarTaskProvider, extraJarTaskProvider, project.getConfigurations().detachedConfiguration(new Dependency[0]), builder -> {}, builder -> {}, dep -> {}, task -> {}, Sets::newHashSet, true);
        });
    }
}

