/*
 * Copyright (c) NeoForged and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */

package net.minecraftforge.common.data;

import java.util.concurrent.CompletableFuture;

import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.extensions.IForgeTagAppender;

public final class ForgeDamageTypeTagsProvider extends DamageTypeTagsProvider
{

    public ForgeDamageTypeTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, ExistingFileHelper existingFileHelper)
    {
        super(output, lookupProvider, "forge", existingFileHelper);
    }

    @Override
    protected void m_6577_(HolderLookup.Provider lookupProvider)
    {
        tag(ForgeMod.POISON_DAMAGE, Tags.DamageTypes.IS_POISON);

        tag(DamageTypes.f_268493_, Tags.DamageTypes.IS_WITHER);
        tag(DamageTypes.f_268641_, Tags.DamageTypes.IS_WITHER);

        tag(DamageTypes.f_268515_, Tags.DamageTypes.IS_MAGIC);
        tag(DamageTypes.f_268530_, Tags.DamageTypes.IS_MAGIC);
        tag(DamageTypes.f_268440_, Tags.DamageTypes.IS_MAGIC);
        tag(DamageTypes.f_268482_, Tags.DamageTypes.IS_MAGIC);
        IForgeTagAppender.addTags(m_206424_(Tags.DamageTypes.IS_MAGIC), Tags.DamageTypes.IS_POISON, Tags.DamageTypes.IS_WITHER);

        tag(DamageTypes.f_268631_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268468_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268546_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268434_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268722_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268441_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268752_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268444_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268450_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268585_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268669_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268513_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268659_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268526_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268613_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268576_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268469_, Tags.DamageTypes.IS_ENVIRONMENT);
        tag(DamageTypes.f_268612_, Tags.DamageTypes.IS_ENVIRONMENT);

        tag(DamageTypes.f_268585_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268669_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268513_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268659_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268526_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268613_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268576_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268469_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268671_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268656_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268566_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268464_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268511_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268739_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268425_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268714_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268534_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268679_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268612_, Tags.DamageTypes.IS_PHYSICAL);
        tag(DamageTypes.f_268433_, Tags.DamageTypes.IS_PHYSICAL);

        tag(DamageTypes.f_286979_, Tags.DamageTypes.IS_TECHNICAL);
        tag(DamageTypes.f_286973_, Tags.DamageTypes.IS_TECHNICAL);
        tag(DamageTypes.f_268724_, Tags.DamageTypes.IS_TECHNICAL);
    }

    @SafeVarargs
    private void tag(ResourceKey<DamageType> type, TagKey<DamageType>... tags)
    {
        for (TagKey<DamageType> key : tags)
        {
            m_206424_(key).m_255204_(type);
        }
    }

    @Override
    public String m_6055_()
    {
        return "Forge Damage Type Tags";
    }
}
