/*
 * Copyright (c) Forge Development LLC and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */

package net.minecraftforge.items.wrapper;

import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlayerArmorInvWrapper extends RangedWrapper
{
    private final Inventory inventoryPlayer;

    public PlayerArmorInvWrapper(Inventory inv)
    {
        super(new InvWrapper(inv), inv.f_35974_.size(), inv.f_35974_.size() + inv.f_35975_.size());
        inventoryPlayer = inv;
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate)
    {
        EquipmentSlot equ = null;
        for (EquipmentSlot s : EquipmentSlot.values())
        {
            if (s.m_20743_() == EquipmentSlot.Type.ARMOR && s.m_20749_() == slot)
            {
                equ = s;
                break;
            }
        }
        // check if it's valid for the armor slot
        if (equ != null && slot < 4 && !stack.m_41619_() && stack.canEquip(equ, getInventoryPlayer().f_35978_))
        {
            return super.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public Inventory getInventoryPlayer()
    {
        return inventoryPlayer;
    }
}
