/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import cpw.mods.jarhandling.SecureJar;
import cpw.mods.modlauncher.api.ServiceRunner;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LibraryFinder;
import net.minecraftforge.fml.loading.VersionInfo;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;

public abstract class CommonServerLaunchHandler
extends CommonLaunchHandler {
    @Override
    public Dist getDist() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public String getNaming() {
        return "srg";
    }

    @Override
    public boolean isProduction() {
        return true;
    }

    @Override
    protected ServiceRunner makeService(String[] arguments, ModuleLayer layer) {
        return () -> this.serverService(arguments, layer);
    }

    @Override
    public CommonLaunchHandler.LocatedPaths getMinecraftPaths() {
        VersionInfo vers = FMLLoader.versionInfo();
        Path mc = LibraryFinder.findPathForMaven("net.minecraft", "server", "", "srg", vers.mcAndMCPVersion());
        Path mcextra = LibraryFinder.findPathForMaven("net.minecraft", "server", "", "extra", vers.mcAndMCPVersion());
        SecureJar mcextra_filtered = SecureJar.from((path, base) -> path.equals("META-INF/versions/") || !path.endsWith(".class") && !path.startsWith("META-INF/"), (Path[])new Path[]{mcextra});
        BiPredicate<String, String> filter = (path, base) -> true;
        Stream.Builder<Path> mcstream = Stream.builder().add(mc).add(mcextra_filtered.getRootPath());
        Stream.Builder<List<Path>> modstream = Stream.builder();
        filter = this.processMCStream(vers, mcstream, filter, modstream);
        Path fmlcore = LibraryFinder.findPathForMaven("net.neoforged.fancymodloader", "core", "", "", vers.fmlVersion());
        Path javafmllang = LibraryFinder.findPathForMaven("net.neoforged.fancymodloader", "language-java", "", "", vers.fmlVersion());
        Path lowcodelang = LibraryFinder.findPathForMaven("net.neoforged.fancymodloader", "language-lowcode", "", "", vers.fmlVersion());
        Path mclang = LibraryFinder.findPathForMaven("net.neoforged.fancymodloader", "language-minecraft", "", "", vers.fmlVersion());
        Path fmlevents = LibraryFinder.findPathForMaven("net.neoforged.fancymodloader", "events", "", "", vers.fmlVersion());
        modstream.add(List.of(fmlevents));
        return new CommonLaunchHandler.LocatedPaths(mcstream.build().toList(), filter, modstream.build().toList(), List.of(fmlcore, javafmllang, lowcodelang, mclang));
    }

    protected abstract BiPredicate<String, String> processMCStream(VersionInfo var1, Stream.Builder<Path> var2, BiPredicate<String, String> var3, Stream.Builder<List<Path>> var4);
}

