/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.targets;

import cpw.mods.modlauncher.api.ServiceRunner;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.LibraryFinder;
import net.minecraftforge.fml.loading.VersionInfo;
import net.minecraftforge.fml.loading.targets.CommonLaunchHandler;

public abstract class CommonClientLaunchHandler
extends CommonLaunchHandler {
    @Override
    public Dist getDist() {
        return Dist.CLIENT;
    }

    @Override
    public String getNaming() {
        return "srg";
    }

    @Override
    public boolean isProduction() {
        return true;
    }

    @Override
    protected ServiceRunner makeService(String[] arguments, ModuleLayer gameLayer) {
        return () -> this.clientService(arguments, gameLayer);
    }

    @Override
    public CommonLaunchHandler.LocatedPaths getMinecraftPaths() {
        VersionInfo vers = FMLLoader.versionInfo();
        Path mc = LibraryFinder.findPathForMaven("net.minecraft", "client", "", "srg", vers.mcAndMCPVersion());
        Path mcextra = LibraryFinder.findPathForMaven("net.minecraft", "client", "", "extra", vers.mcAndMCPVersion());
        Stream.Builder<Path> mcstream = Stream.builder().add(mc).add(mcextra);
        Stream.Builder<List<Path>> modstream = Stream.builder();
        this.processMCStream(vers, mcstream, modstream);
        Path fmlevents = LibraryFinder.findPathForMaven("net.neoforged.fancymodloader", "events", "", "", vers.fmlVersion());
        Path fmlcore = LibraryFinder.findPathForMaven("net.neoforged.fancymodloader", "core", "", "", vers.fmlVersion());
        Path javafmllang = LibraryFinder.findPathForMaven("net.neoforged.fancymodloader", "language-java", "", "", vers.fmlVersion());
        Path lowcodelang = LibraryFinder.findPathForMaven("net.neoforged.fancymodloader", "language-lowcode", "", "", vers.fmlVersion());
        Path mclang = LibraryFinder.findPathForMaven("net.neoforged.fancymodloader", "language-minecraft", "", "", vers.fmlVersion());
        return new CommonLaunchHandler.LocatedPaths(mcstream.build().toList(), (a, b) -> true, modstream.build().toList(), List.of(fmlcore, javafmllang, lowcodelang, mclang));
    }

    protected abstract void processMCStream(VersionInfo var1, Stream.Builder<Path> var2, Stream.Builder<List<Path>> var3);
}

