/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml;

import java.nio.file.Path;
import java.util.List;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import org.jetbrains.annotations.Nullable;

public record ModLoadingIssue(Severity severity, String translationKey, List<Object> translationArgs, @Nullable Throwable cause, @Nullable Path affectedPath, @Nullable IModFile affectedModFile, @Nullable IModInfo affectedMod) {
    public ModLoadingIssue(Severity severity, String translationKey, List<Object> translationArgs) {
        this(severity, translationKey, translationArgs, null, null, null, null);
    }

    public ModLoadingIssue(Severity severity, String translationKey, List<Object> translationArgs, @Nullable Throwable cause, @Nullable Path affectedPath, @Nullable IModFile affectedModFile, @Nullable IModInfo affectedMod) {
        if (translationKey.startsWith("fml.") && !translationKey.startsWith("fml.modloadingissue.")) {
            throw new IllegalArgumentException("When using FML translation keys, only use fml.modloadingissue. keys for mod loading issues: " + translationKey);
        }
    }

    public static ModLoadingIssue error(String translationKey, Object ... args) {
        return new ModLoadingIssue(Severity.ERROR, translationKey, List.of(args));
    }

    public static ModLoadingIssue warning(String translationKey, Object ... args) {
        return new ModLoadingIssue(Severity.WARNING, translationKey, List.of(args));
    }

    public ModLoadingIssue withAffectedPath(Path affectedPath) {
        return new ModLoadingIssue(this.severity, this.translationKey, this.translationArgs, this.cause, affectedPath, null, null);
    }

    public ModLoadingIssue withAffectedModFile(IModFile affectedModFile) {
        Path affectedPath = affectedModFile.getFilePath();
        return new ModLoadingIssue(this.severity, this.translationKey, this.translationArgs, this.cause, affectedPath, affectedModFile, null);
    }

    public ModLoadingIssue withAffectedMod(IModInfo affectedMod) {
        IModFile affectedModFile = affectedMod.getOwningFile().getFile();
        Path affectedPath = affectedModFile.getFilePath();
        return new ModLoadingIssue(this.severity, this.translationKey, this.translationArgs, this.cause, affectedPath, affectedModFile, affectedMod);
    }

    public ModLoadingIssue withCause(Throwable cause) {
        return new ModLoadingIssue(this.severity, this.translationKey, this.translationArgs, cause, this.affectedPath, this.affectedModFile, this.affectedMod);
    }

    public ModLoadingIssue withSeverity(Severity severity) {
        return new ModLoadingIssue(severity, this.translationKey, this.translationArgs, this.cause, this.affectedPath, this.affectedModFile, this.affectedMod);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(String.valueOf((Object)this.severity) + ": " + this.translationKey);
        if (!this.translationArgs.isEmpty()) {
            result.append(" [");
            for (int i = 0; i < this.translationArgs.size(); ++i) {
                if (i > 0) {
                    result.append("; ");
                }
                result.append(this.translationArgs.get(i));
            }
            result.append("]");
        }
        if (this.cause != null) {
            result.append(" caused by ").append(this.cause);
        }
        return result.toString();
    }

    public static enum Severity {
        WARNING,
        ERROR;

    }
}

