/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Function;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.loading.StringUtils;

public class ModConfig {
    private final Type type;
    private final IConfigSpec<?> spec;
    private final String fileName;
    protected final ModContainer container;
    private CommentedConfig configData;

    public ModConfig(Type type, IConfigSpec<?> spec, ModContainer container, String fileName) {
        this.type = type;
        this.spec = spec;
        this.fileName = fileName;
        this.container = container;
        ConfigTracker.INSTANCE.trackConfig(this);
    }

    public ModConfig(Type type, IConfigSpec<?> spec, ModContainer activeContainer) {
        this(type, spec, activeContainer, ModConfig.defaultConfigName(type, activeContainer.getModId()));
    }

    private static String defaultConfigName(Type type, String modId) {
        return String.format(Locale.ROOT, "%s-%s.toml", modId, type.extension());
    }

    public Type getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public <T extends IConfigSpec<T>> IConfigSpec<T> getSpec() {
        return this.spec;
    }

    public String getModId() {
        return this.container.getModId();
    }

    public CommentedConfig getConfigData() {
        return this.configData;
    }

    void setConfigData(CommentedConfig configData) {
        this.configData = configData;
        this.spec.acceptConfig(this.configData);
    }

    public void save() {
        ((FileConfig)this.configData).save();
    }

    public Path getFullPath() {
        return ((FileConfig)this.configData).getNioPath();
    }

    public void acceptSyncedConfig(byte[] bytes) {
        this.setConfigData((CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(bytes)));
        this.postConfigEvent(ModConfigEvent.Reloading::new);
    }

    void postConfigEvent(Function<ModConfig, ModConfigEvent> constructor) {
        this.container.acceptEvent(constructor.apply(this));
    }

    public static enum Type {
        COMMON,
        CLIENT,
        SERVER,
        STARTUP;


        public String extension() {
            return StringUtils.toLowerCase(this.name());
        }
    }
}

