/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.slf4j.Logger;

public class UniqueModListBuilder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<ModFile> modFiles;

    public UniqueModListBuilder(List<ModFile> modFiles) {
        this.modFiles = modFiles;
    }

    public UniqueModListData buildUniqueList() {
        Map<String, List<ModFile>> modFilesByFirstId = this.modFiles.stream().filter(mf -> mf.getModFileInfo() != null).collect(Collectors.groupingBy(UniqueModListBuilder::getModId));
        Map<String, List<ModFile>> libFilesWithVersionByModuleName = this.modFiles.stream().filter(mf -> mf.getModFileInfo() == null).collect(Collectors.groupingBy(UniqueModListBuilder::getModId));
        List<ModFile> uniqueModList = modFilesByFirstId.entrySet().stream().map(this::selectNewestModInfo).toList();
        List<ModFile> uniqueLibListWithVersion = libFilesWithVersionByModuleName.entrySet().stream().map(this::selectNewestModInfo).toList();
        Map<String, List<IModInfo>> modIds = uniqueModList.stream().filter(mf -> mf.getModFileInfo() != null).map(ModFile::getModInfos).flatMap(Collection::stream).collect(Collectors.groupingBy(IModInfo::getModId));
        Map versionedLibIds = uniqueLibListWithVersion.stream().map(UniqueModListBuilder::getModId).collect(Collectors.toMap(Function.identity(), libFilesWithVersionByModuleName::get));
        List<String> dupedModErrors = modIds.values().stream().filter(modInfos -> modInfos.size() > 1).map(mods -> String.format("\tMod ID: '%s' from mod files: %s", ((IModInfo)mods.get(0)).getModId(), mods.stream().map(modInfo -> modInfo.getOwningFile().getFile().getFileName()).collect(Collectors.joining(", ")))).toList();
        if (!dupedModErrors.isEmpty()) {
            LOGGER.error(LogMarkers.LOADING, "Found duplicate mods:\n{}", (Object)String.join((CharSequence)"\n", dupedModErrors));
            throw new ModLoadingException(dupedModErrors.stream().map(x$0 -> ModLoadingIssue.error(x$0, new Object[0])).toList());
        }
        List<String> dupedLibErrors = versionedLibIds.values().stream().filter(modFiles -> modFiles.size() > 1).map(mods -> String.format("\tLibrary: '%s' from files: %s", UniqueModListBuilder.getModId((ModFile)mods.get(0)), mods.stream().map(modFile -> modFile.getFileName()).collect(Collectors.joining(", ")))).toList();
        if (!dupedLibErrors.isEmpty()) {
            LOGGER.error(LogMarkers.LOADING, "Found duplicate plugins or libraries:\n{}", (Object)String.join((CharSequence)"\n", dupedLibErrors));
            throw new ModLoadingException(dupedLibErrors.stream().map(x$0 -> ModLoadingIssue.error(x$0, new Object[0])).toList());
        }
        Map<String, List<ModFile>> uniqueModFilesByFirstId = uniqueModList.stream().collect(Collectors.groupingBy(UniqueModListBuilder::getModId));
        ArrayList<ModFile> loadedList = new ArrayList<ModFile>();
        loadedList.addAll(uniqueModList);
        loadedList.addAll(uniqueLibListWithVersion);
        return new UniqueModListData(loadedList, uniqueModFilesByFirstId);
    }

    private ModFile selectNewestModInfo(Map.Entry<String, List<ModFile>> fullList) {
        List<ModFile> modInfoList = fullList.getValue();
        if (modInfoList.size() > 1) {
            LOGGER.debug("Found {} mods for first modid {}, selecting most recent based on version data", (Object)modInfoList.size(), (Object)fullList.getKey());
            modInfoList.sort(Comparator.comparing(this::getVersion).reversed());
            LOGGER.debug("Selected file {} for modid {} with version {}", new Object[]{modInfoList.get(0).getFileName(), fullList.getKey(), this.getVersion(modInfoList.get(0))});
        }
        return modInfoList.get(0);
    }

    private ArtifactVersion getVersion(ModFile mf) {
        if (mf.getModFileInfo() == null || mf.getModInfos() == null || mf.getModInfos().isEmpty()) {
            return mf.getJarVersion();
        }
        return mf.getModInfos().get(0).getVersion();
    }

    private static String getModId(ModFile modFile) {
        if (modFile.getModFileInfo() == null || modFile.getModFileInfo().getMods().isEmpty()) {
            return modFile.getSecureJar().name();
        }
        return modFile.getModFileInfo().moduleName();
    }

    public record UniqueModListData(List<ModFile> modFiles, Map<String, List<ModFile>> modFilesByFirstId) {
    }
}

