/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;

public final class TransformerDiscovererConstants {
    public static final Set<String> SERVICES = Set.of("cpw.mods.modlauncher.api.ITransformationService", "net.neoforged.neoforgespi.locating.IModLocator", "net.neoforged.neoforgespi.locating.IDependencyLocator", "net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper", "net.neoforged.fml.loading.ImmediateWindowProvider", "net.neoforged.neoforgespi.earlywindow.ImmediateWindowProvider");

    private TransformerDiscovererConstants() {
    }

    public static boolean shouldLoadInServiceLayer(Collection<Path> paths) {
        return TransformerDiscovererConstants.shouldLoadInServiceLayer(JarContents.of(paths));
    }

    public static boolean shouldLoadInServiceLayer(Path path) {
        return TransformerDiscovererConstants.shouldLoadInServiceLayer(JarContents.of((Path)path));
    }

    public static boolean shouldLoadInServiceLayer(JarContents jarContents) {
        JarMetadata metadata = JarMetadata.from((JarContents)jarContents);
        return metadata.providers().stream().map(SecureJar.Provider::serviceName).anyMatch(SERVICES::contains);
    }
}

