/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.neoforged.fml.loading.MavenCoordinate;

public class LibraryFinder {
    static Path findLibsPath() {
        String libraryDirectoryProp = System.getProperty("libraryDirectory");
        if (libraryDirectoryProp == null) {
            throw new IllegalStateException("Missing libraryDirectory system property");
        }
        Path libsPath = Path.of(libraryDirectoryProp, new String[0]);
        if (!Files.isDirectory(libsPath, new LinkOption[0])) {
            throw new IllegalStateException("libraryDirectory system property refers to a non-directory: " + String.valueOf(libsPath));
        }
        return libsPath;
    }

    public static Path findPathForMaven(String group, String artifact, String extension, String classifier, String version) {
        return LibraryFinder.findPathForMaven(new MavenCoordinate(group, artifact, extension, classifier, version));
    }

    public static Path findPathForMaven(MavenCoordinate artifact) {
        return LibraryFinder.findLibsPath().resolve(artifact.toRelativeRepositoryPath());
    }
}

