/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import com.mojang.logging.LogUtils;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.ImmediateWindowHandler;
import net.neoforged.fml.loading.JarVersionLookupHandler;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.VersionSupportMatrix;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.util.ServiceLoaderUtil;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.language.IModLanguageLoader;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;

public class LanguageProviderLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<IModLanguageLoader> languageProviders;
    private final Map<String, ModLanguageWrapper> languageProviderMap = new HashMap<String, ModLanguageWrapper>();

    public void forEach(Consumer<IModLanguageLoader> consumer) {
        this.languageProviders.forEach(consumer);
    }

    public <T> Stream<T> applyForEach(Function<IModLanguageLoader, T> function) {
        return this.languageProviders.stream().map(function);
    }

    LanguageProviderLoader(ILaunchContext launchContext) {
        this.languageProviders = ServiceLoaderUtil.loadServices(launchContext, IModLanguageLoader.class);
        ImmediateWindowHandler.updateProgress("Loading language providers");
        this.languageProviders.forEach((? super T lp) -> {
            Path lpPath;
            try {
                lpPath = Paths.get(lp.getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Huh?", e);
            }
            Optional<String> version = JarVersionLookupHandler.getVersion(lp.getClass());
            String impl = version.orElse(Files.isDirectory(lpPath, new LinkOption[0]) ? FMLLoader.versionInfo().fmlVersion().split("\\.")[0] : null);
            if (impl == null) {
                LOGGER.error(LogMarkers.CORE, "Found unversioned language provider {}", (Object)lp.name());
                throw new RuntimeException("Failed to find implementation version for language provider " + lp.name());
            }
            LOGGER.debug(LogMarkers.CORE, "Found language provider {}, version {}", (Object)lp.name(), (Object)impl);
            ImmediateWindowHandler.updateProgress("Loaded language provider " + lp.name() + " " + impl);
            this.languageProviderMap.put(lp.name(), new ModLanguageWrapper((IModLanguageLoader)lp, (ArtifactVersion)new DefaultArtifactVersion(impl)));
        });
    }

    public IModLanguageLoader findLanguage(ModFile mf, String modLoader, VersionRange modLoaderVersion) {
        String languageFileName = mf.getFileName();
        ModLanguageWrapper mlw = this.languageProviderMap.get(modLoader);
        if (mlw == null) {
            LOGGER.error(LogMarkers.LOADING, "Missing language {} version {} wanted by {}", new Object[]{modLoader, modLoaderVersion, languageFileName});
            throw new ModLoadingException(ModLoadingIssue.error("fml.language.missingversion", modLoader, modLoaderVersion, languageFileName, "null").withAffectedModFile(mf));
        }
        if (!VersionSupportMatrix.testVersionSupportMatrix(modLoaderVersion, modLoader, "languageloader", (llid, range) -> range.containsVersion(mlw.version()))) {
            LOGGER.error(LogMarkers.LOADING, "Missing language {} version {} wanted by {}, found {}", new Object[]{modLoader, modLoaderVersion, languageFileName, mlw.version()});
            throw new ModLoadingException(ModLoadingIssue.error("fml.language.missingversion", modLoader, modLoaderVersion, languageFileName, mlw.version()).withAffectedModFile(mf));
        }
        return mlw.modLanguageProvider();
    }

    private record ModLanguageWrapper(IModLanguageLoader modLanguageProvider, ArtifactVersion version) {
    }
}

