/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.targets;

import cpw.mods.jarhandling.JarContents;
import cpw.mods.jarhandling.JarContentsBuilder;
import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.LibraryFinder;
import net.neoforged.fml.loading.VersionInfo;
import net.neoforged.fml.loading.targets.CommonLaunchHandler;

public abstract class CommonServerLaunchHandler
extends CommonLaunchHandler {
    @Override
    public Dist getDist() {
        return Dist.DEDICATED_SERVER;
    }

    @Override
    public String getNaming() {
        return "srg";
    }

    @Override
    public boolean isProduction() {
        return true;
    }

    @Override
    protected void runService(String[] arguments, ModuleLayer gameLayer) throws Throwable {
        this.serverService(arguments, gameLayer);
    }

    @Override
    public CommonLaunchHandler.LocatedPaths getMinecraftPaths() {
        VersionInfo vers = FMLLoader.versionInfo();
        Path mc = LibraryFinder.findPathForMaven("net.minecraft", "server", "", "srg", vers.mcAndNeoFormVersion());
        Path mcextra = LibraryFinder.findPathForMaven("net.minecraft", "server", "", "extra", vers.mcAndNeoFormVersion());
        SecureJar mcextra_filtered = SecureJar.from((JarContents)new JarContentsBuilder().pathFilter((path, base) -> path.equals("META-INF/versions/") || !path.endsWith(".class") && !path.startsWith("META-INF/")).paths(new Path[]{mcextra}).build());
        Stream.Builder<Path> mcstream = Stream.builder().add(mc).add(mcextra_filtered.getRootPath());
        Stream.Builder<List<Path>> modstream = Stream.builder();
        this.processMCStream(vers, mcstream, modstream);
        return new CommonLaunchHandler.LocatedPaths(mcstream.build().toList(), null, modstream.build().toList(), this.getFmlPaths(this.getLegacyClasspath()));
    }

    protected abstract void processMCStream(VersionInfo var1, Stream.Builder<Path> var2, Stream.Builder<List<Path>> var3);
}

