/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.StringSubstitutor;
import net.neoforged.fml.loading.StringUtils;
import net.neoforged.fml.loading.moddiscovery.InvalidModFileException;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.neoforgespi.language.IConfigurable;
import net.neoforged.neoforgespi.language.IModInfo;
import net.neoforged.neoforgespi.language.MavenVersionAdapter;
import net.neoforged.neoforgespi.locating.ForgeFeature;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;

public class ModInfo
implements IModInfo,
IConfigurable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DefaultArtifactVersion DEFAULT_VERSION = new DefaultArtifactVersion("1");
    private static final Pattern VALID_MODID = Pattern.compile("^[a-z][a-z0-9_]{1,63}$");
    private static final Pattern VALID_NAMESPACE = Pattern.compile("^[a-z][a-z0-9_.-]{1,63}$");
    private static final Pattern VALID_VERSION = Pattern.compile("^\\d+.*");
    private final ModFileInfo owningFile;
    private final String modId;
    private final String namespace;
    private final ArtifactVersion version;
    private final String displayName;
    private final String description;
    private final Optional<String> logoFile;
    private final boolean logoBlur;
    private final Optional<URL> updateJSONURL;
    private final List<? extends IModInfo.ModVersion> dependencies;
    private final List<ForgeFeature.Bound> features;
    private final Map<String, Object> properties;
    private final IConfigurable config;
    private final Optional<URL> modUrl;

    public ModInfo(ModFileInfo owningFile, IConfigurable config) {
        Optional<ModFileInfo> ownFile = Optional.ofNullable(owningFile);
        this.owningFile = owningFile;
        this.config = config;
        this.modId = (String)config.getConfigElement(new String[]{"modId"}).orElseThrow(() -> new InvalidModFileException("Missing modId", owningFile));
        if (!VALID_MODID.matcher(this.modId).matches()) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Invalid modId found in file {} - {} does not match the standard: {}", new Object[]{this.owningFile.getFile().getFilePath(), this.modId, VALID_MODID.pattern()});
            throw new InvalidModFileException("Invalid modId found : " + this.modId, owningFile);
        }
        this.namespace = config.getConfigElement(new String[]{"namespace"}).orElse(this.modId);
        if (!VALID_NAMESPACE.matcher(this.namespace).matches()) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Invalid override namespace found in file {} - {} does not match the standard: {}", new Object[]{this.owningFile.getFile().getFilePath(), this.namespace, VALID_NAMESPACE.pattern()});
            throw new InvalidModFileException("Invalid override namespace found : " + this.namespace, owningFile);
        }
        this.version = (ArtifactVersion)config.getConfigElement(new String[]{"version"}).map(s -> StringSubstitutor.replace(s, ownFile.map(ModFileInfo::getFile).orElse(null))).map(DefaultArtifactVersion::new).orElse(DEFAULT_VERSION);
        if (!VALID_VERSION.matcher(this.version.toString()).matches()) {
            throw new InvalidModFileException("Illegal version number specified " + this.version, this.getOwningFile());
        }
        this.displayName = config.getConfigElement(new String[]{"displayName"}).orElse(this.modId);
        this.description = config.getConfigElement(new String[]{"description"}).map(desc -> desc.replace("\r\n", "\n")).orElse("MISSING DESCRIPTION");
        this.logoFile = Optional.ofNullable(config.getConfigElement(new String[]{"logoFile"}).orElseGet(() -> ownFile.flatMap(mf -> mf.getConfigElement("logoFile")).orElse(null)));
        this.logoBlur = config.getConfigElement(new String[]{"logoBlur"}).orElseGet(() -> ownFile.flatMap(f -> f.getConfigElement("logoBlur")).orElse(true));
        this.updateJSONURL = config.getConfigElement(new String[]{"updateJSONURL"}).map(StringUtils::toURL);
        this.modUrl = config.getConfigElement(new String[]{"modUrl"}).map(StringUtils::toURL);
        this.dependencies = ownFile.map(mfi -> mfi.getConfigList("dependencies", this.modId)).orElse(Collections.emptyList()).stream().map(dep -> new ModVersion(this, (IConfigurable)dep)).toList();
        this.features = ownFile.flatMap(mfi -> mfi.getConfigElement("features", this.modId)).stream().flatMap(m -> m.entrySet().stream()).map(this::makeBound).toList();
        this.properties = ownFile.flatMap(mfi -> mfi.getConfigElement("modproperties", this.modId)).orElse(Collections.emptyMap());
    }

    public ModFileInfo getOwningFile() {
        return this.owningFile;
    }

    public String getModId() {
        return this.modId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public ArtifactVersion getVersion() {
        return this.version;
    }

    public List<? extends IModInfo.ModVersion> getDependencies() {
        return this.dependencies;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, Object> getModProperties() {
        return this.properties;
    }

    public Optional<URL> getUpdateURL() {
        return this.updateJSONURL;
    }

    public Optional<String> getLogoFile() {
        return this.logoFile;
    }

    public boolean getLogoBlur() {
        return this.logoBlur;
    }

    public IConfigurable getConfig() {
        return this;
    }

    public List<? extends ForgeFeature.Bound> getForgeFeatures() {
        return this.features;
    }

    public <T> Optional<T> getConfigElement(String ... key) {
        return this.config.getConfigElement(key);
    }

    public List<? extends IConfigurable> getConfigList(String ... key) {
        return null;
    }

    public Optional<URL> getModURL() {
        return this.modUrl;
    }

    private ForgeFeature.Bound makeBound(Map.Entry<String, Object> e) {
        Object object = e.getValue();
        if (object instanceof String) {
            String val = (String)object;
            return new ForgeFeature.Bound(e.getKey(), val, (IModInfo)this);
        }
        throw new InvalidModFileException("Invalid feature bound {" + e.getValue() + "} for key {" + e.getKey() + "} only strings are accepted", this.owningFile);
    }

    class ModVersion
    implements IModInfo.ModVersion {
        private IModInfo owner;
        private final String modId;
        private final VersionRange versionRange;
        private final IModInfo.DependencyType type;
        private final Optional<String> reason;
        private final IModInfo.Ordering ordering;
        private final IModInfo.DependencySide side;
        private Optional<URL> referralUrl;

        public ModVersion(IModInfo owner, IConfigurable config) {
            this.owner = owner;
            this.modId = (String)config.getConfigElement(new String[]{"modId"}).orElseThrow(() -> new InvalidModFileException("Missing required field modid in dependency", ModInfo.this.getOwningFile()));
            this.type = config.getConfigElement(new String[]{"type"}).map(str -> str.toUpperCase(Locale.ROOT)).map(IModInfo.DependencyType::valueOf).orElseGet(() -> {
                Optional mandatory = config.getConfigElement(new String[]{"mandatory"});
                if (mandatory.isPresent()) {
                    if (!FMLLoader.isProduction()) {
                        LOGGER.error("Mod '{}' uses deprecated 'mandatory' field in the dependency declaration for '{}'. Use the 'type' field and 'required'/'optional' instead", (Object)owner.getModId(), (Object)this.modId);
                        throw new InvalidModFileException("Deprecated 'mandatory' field is used in dependency", ModInfo.this.getOwningFile());
                    }
                    return (Boolean)mandatory.get() != false ? IModInfo.DependencyType.REQUIRED : IModInfo.DependencyType.OPTIONAL;
                }
                return IModInfo.DependencyType.REQUIRED;
            });
            this.reason = config.getConfigElement(new String[]{"reason"});
            this.versionRange = config.getConfigElement(new String[]{"versionRange"}).map(MavenVersionAdapter::createFromVersionSpec).orElse(IModInfo.UNBOUNDED);
            this.ordering = config.getConfigElement(new String[]{"ordering"}).map(IModInfo.Ordering::valueOf).orElse(IModInfo.Ordering.NONE);
            this.side = config.getConfigElement(new String[]{"side"}).map(IModInfo.DependencySide::valueOf).orElse(IModInfo.DependencySide.BOTH);
            this.referralUrl = config.getConfigElement(new String[]{"referralUrl"}).map(StringUtils::toURL);
        }

        public String getModId() {
            return this.modId;
        }

        public VersionRange getVersionRange() {
            return this.versionRange;
        }

        public IModInfo.DependencyType getType() {
            return this.type;
        }

        public Optional<String> getReason() {
            return this.reason;
        }

        public IModInfo.Ordering getOrdering() {
            return this.ordering;
        }

        public IModInfo.DependencySide getSide() {
            return this.side;
        }

        public void setOwner(IModInfo owner) {
            this.owner = owner;
        }

        public IModInfo getOwner() {
            return this.owner;
        }

        public Optional<URL> getReferralURL() {
            return this.referralUrl;
        }
    }
}

