/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import net.neoforged.fml.loading.EarlyLoadingException;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.mixin.DeferredMixinConfigRegistration;
import net.neoforged.fml.loading.moddiscovery.BackgroundScanHandler;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.neoforgespi.coremod.ICoreModProvider;
import net.neoforged.neoforgespi.locating.IModFile;

public class LoadingModList {
    private static LoadingModList INSTANCE;
    private final List<ModFileInfo> modFiles;
    private final List<ModInfo> sortedList;
    private final Map<String, ModFileInfo> fileById;
    private final List<EarlyLoadingException> preLoadErrors;
    private final List<EarlyLoadingException> preLoadWarnings;
    private List<IModFile> brokenFiles;

    private LoadingModList(List<ModFile> modFiles, List<ModInfo> sortedList) {
        this.modFiles = modFiles.stream().map(ModFile::getModFileInfo).map(ModFileInfo.class::cast).collect(Collectors.toList());
        this.sortedList = sortedList.stream().map(ModInfo.class::cast).collect(Collectors.toList());
        this.fileById = this.modFiles.stream().map(ModFileInfo::getMods).flatMap(Collection::stream).map(ModInfo.class::cast).collect(Collectors.toMap(ModInfo::getModId, ModInfo::getOwningFile));
        this.preLoadErrors = new ArrayList<EarlyLoadingException>();
        this.preLoadWarnings = new ArrayList<EarlyLoadingException>();
    }

    public static LoadingModList of(List<ModFile> modFiles, List<ModInfo> sortedList, EarlyLoadingException earlyLoadingException) {
        INSTANCE = new LoadingModList(modFiles, sortedList);
        if (earlyLoadingException != null) {
            LoadingModList.INSTANCE.preLoadErrors.add(earlyLoadingException);
        }
        return INSTANCE;
    }

    public static LoadingModList get() {
        return INSTANCE;
    }

    public void addCoreMods() {
        this.modFiles.stream().map(ModFileInfo::getFile).map(ModFile::getCoreMods).flatMap(Collection::stream).forEach(arg_0 -> ((ICoreModProvider)FMLLoader.getCoreModProvider()).addCoreMod(arg_0));
    }

    public void addMixinConfigs() {
        this.modFiles.stream().map(ModFileInfo::getFile).map(ModFile::getMixinConfigs).flatMap(Collection::stream).forEach(DeferredMixinConfigRegistration::addMixinConfig);
    }

    public void addAccessTransformers() {
        this.modFiles.stream().map(ModFileInfo::getFile).forEach(mod -> mod.getAccessTransformers().forEach(path -> FMLLoader.addAccessTransformer(path, mod)));
    }

    public void addForScanning(BackgroundScanHandler backgroundScanHandler) {
        backgroundScanHandler.setLoadingModList(this);
        this.modFiles.stream().map(ModFileInfo::getFile).forEach(backgroundScanHandler::submitForScanning);
    }

    public List<ModFileInfo> getModFiles() {
        return this.modFiles;
    }

    public Path findResource(String className) {
        for (ModFileInfo mf : this.modFiles) {
            Path resource = mf.getFile().findResource(className);
            if (!Files.exists(resource, new LinkOption[0])) continue;
            return resource;
        }
        return null;
    }

    public Enumeration<URL> findAllURLsForResource(String resName) {
        final String resourceName = resName.startsWith("/") ? resName.substring(1) : resName;
        return new Enumeration<URL>(){
            private final Iterator<ModFileInfo> modFileIterator;
            private URL next;
            {
                this.modFileIterator = LoadingModList.this.modFiles.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                if (this.next != null) {
                    return true;
                }
                this.next = this.findNextURL();
                return this.next != null;
            }

            @Override
            public URL nextElement() {
                if (this.next == null) {
                    this.next = this.findNextURL();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                URL result = this.next;
                this.next = null;
                return result;
            }

            private URL findNextURL() {
                while (this.modFileIterator.hasNext()) {
                    ModFileInfo next = this.modFileIterator.next();
                    Path resource = next.getFile().findResource(resourceName);
                    if (!Files.exists(resource, new LinkOption[0])) continue;
                    return (URL)LamdbaExceptionUtils.uncheck(() -> new URL("modjar://" + next.getMods().get(0).getModId() + "/" + resourceName));
                }
                return null;
            }
        };
    }

    public ModFileInfo getModFileById(String modid) {
        return this.fileById.get(modid);
    }

    public List<ModInfo> getMods() {
        return this.sortedList;
    }

    public List<EarlyLoadingException> getErrors() {
        return this.preLoadErrors;
    }

    public List<EarlyLoadingException> getWarnings() {
        return this.preLoadWarnings;
    }

    public void setBrokenFiles(List<IModFile> brokenFiles) {
        this.brokenFiles = brokenFiles;
    }

    public List<IModFile> getBrokenFiles() {
        return this.brokenFiles;
    }
}

