/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforgespi.transformation;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.neoforged.neoforgespi.transformation.BaseSimpleProcessor;
import net.neoforged.neoforgespi.transformation.ClassProcessor;
import net.neoforged.neoforgespi.transformation.NameValidation;
import net.neoforged.neoforgespi.transformation.SimpleTransformationContext;
import org.objectweb.asm.tree.FieldNode;

public abstract non-sealed class SimpleFieldProcessor
extends BaseSimpleProcessor {
    private final AtomicReference<Map<String, Set<String>>> targetsByClass = new AtomicReference();

    public abstract void transform(FieldNode var1, SimpleTransformationContext var2);

    public abstract Set<Target> targets();

    private Map<String, Set<String>> targetsByClass() {
        return this.targetsByClass.updateAndGet(map -> map != null ? map : this.targets().stream().collect(Collectors.groupingBy(Target::className, Collectors.mapping(Target::fieldName, Collectors.toSet()))));
    }

    @Override
    public final boolean handlesClass(ClassProcessor.SelectionContext context) {
        return this.targetsByClass().containsKey(context.type().getClassName());
    }

    @Override
    public final ClassProcessor.ComputeFlags processClass(ClassProcessor.TransformationContext context) {
        Set<String> targetFields = this.targetsByClass().get(context.type().getClassName());
        if (targetFields == null) {
            return ClassProcessor.ComputeFlags.NO_REWRITE;
        }
        boolean transformed = false;
        for (FieldNode field : context.node().fields) {
            if (!targetFields.contains(field.name)) continue;
            this.transform(field, context);
            transformed = true;
        }
        return transformed ? ClassProcessor.ComputeFlags.COMPUTE_FRAMES : ClassProcessor.ComputeFlags.NO_REWRITE;
    }

    public record Target(String className, String fieldName) {
        public Target {
            NameValidation.validateClassName(className);
            NameValidation.validateUnqualified(fieldName);
        }
    }
}

