/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery.locators;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.ModLoadingException;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.loading.LibraryFinder;
import net.neoforged.fml.loading.MavenCoordinate;
import net.neoforged.fml.loading.VersionInfo;
import net.neoforged.fml.loading.moddiscovery.ModJarMetadata;
import net.neoforged.fml.loading.moddiscovery.locators.MinecraftModInfo;
import net.neoforged.fml.loading.moddiscovery.locators.NeoForgeDevDistCleaner;
import net.neoforged.fml.loading.moddiscovery.locators.RequiredSystemFiles;
import net.neoforged.fml.loading.moddiscovery.readers.JarModsDotTomlModFileReader;
import net.neoforged.fml.util.ClasspathResourceUtils;
import net.neoforged.fml.util.PathPrettyPrinting;
import net.neoforged.neoforgespi.ILaunchContext;
import net.neoforged.neoforgespi.locating.IDiscoveryPipeline;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.IModFileCandidateLocator;
import net.neoforged.neoforgespi.locating.IncompatibleFileReporting;
import net.neoforged.neoforgespi.locating.ModFileDiscoveryAttributes;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameLocator
implements IModFileCandidateLocator {
    private static final Logger LOG = LoggerFactory.getLogger(GameLocator.class);
    public static final String LIBRARIES_DIRECTORY_PROPERTY = "libraryDirectory";
    public static final String[] NEOFORGE_SPECIFIC_PATH_PREFIXES = new String[]{"net/neoforged/neoforge/", "META-INF/services/", "META-INF/neoforge.mods.toml"};

    @Override
    public void findCandidates(ILaunchContext context, IDiscoveryPipeline pipeline) {
        ClassLoader ourCl = Thread.currentThread().getContextClassLoader();
        this.preventLoadingOfObfuscatedClientJar(context, ourCl);
        try (RequiredSystemFiles systemFiles = RequiredSystemFiles.find(context, ourCl);){
            if (!systemFiles.isEmpty()) {
                systemFiles.checkForMissingMinecraftFiles(context.getRequiredDistribution() == Dist.CLIENT);
                GameLocator.handleMergedMinecraftAndNeoForgeJar(context, pipeline, systemFiles);
                return;
            }
            LOG.info("Failed to find common Minecraft classes and resources on the classpath. Assuming we're launching production.");
        }
        GameLocator.locateProductionMinecraft(context, pipeline);
    }

    private static void handleMergedMinecraftAndNeoForgeJar(ILaunchContext context, IDiscoveryPipeline pipeline, RequiredSystemFiles systemFiles) {
        JarContents nfJarContents;
        IModFile minecraftModFile;
        LOG.info("Detected a joined NeoForge and Minecraft configuration. Applying filtering...");
        JarContents mcJarContents = GameLocator.getCombinedMinecraftJar(context, systemFiles);
        if (mcJarContents.containsFile("META-INF/neoforged.mods.toml")) {
            minecraftModFile = pipeline.addJarContent(mcJarContents, ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.IGNORE).orElse(null);
            if (minecraftModFile == null) {
                throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_minecraft_jar", new Object[0]));
            }
        } else {
            String minecraftVersion = GameLocator.detectMinecraftVersion(mcJarContents);
            ModJarMetadata mcJarMetadata = new ModJarMetadata();
            minecraftModFile = IModFile.create(mcJarContents, mcJarMetadata, new MinecraftModInfo(minecraftVersion)::buildMinecraftModInfo);
            mcJarMetadata.setModFile(minecraftModFile);
            if (!pipeline.addModFile(minecraftModFile)) {
                throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_minecraft_jar", new Object[0]));
            }
        }
        if (!minecraftModFile.getId().equals("minecraft")) {
            LOG.error("The mod id for the Minecraft jar is not 'minecraft': {}", (Object)minecraftModFile.getId());
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_minecraft_jar", new Object[0]));
        }
        JarContents.PathFilter nfJarFilter = relativePath -> {
            if (!relativePath.endsWith(".class")) {
                return true;
            }
            for (String includedPrefix : NEOFORGE_SPECIFIC_PATH_PREFIXES) {
                if (!relativePath.startsWith(includedPrefix)) continue;
                return true;
            }
            return false;
        };
        ArrayList<JarContents.FilteredPath> nfJarRoots = new ArrayList<JarContents.FilteredPath>();
        for (JarContents nfJarRoot : systemFiles.getNeoForgeJarComponents()) {
            nfJarRoots.add(new JarContents.FilteredPath(nfJarRoot.getPrimaryPath(), nfJarFilter));
        }
        try {
            nfJarContents = JarContents.ofFilteredPaths(nfJarRoots);
        }
        catch (IOException e) {
            LOG.error("Failed to construct filtered NeoForge jar from {}", nfJarRoots);
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_neoforge_jar", new Object[0]).withCause(e));
        }
        IModFile modFile = JarModsDotTomlModFileReader.createModFile(nfJarContents, ModFileDiscoveryAttributes.DEFAULT);
        if (modFile == null) {
            LOG.error("Failed to construct NeoForge mod file from {}", (Object)nfJarContents);
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_neoforge_jar", new Object[0]));
        }
        pipeline.addModFile(modFile);
        systemFiles.getAll().stream().map(JarContents::getPrimaryPath).forEach(context::addLocated);
    }

    private static JarContents getCombinedMinecraftJar(ILaunchContext context, RequiredSystemFiles systemFiles) {
        JarContents mcJarContents;
        if (systemFiles.getCommonResources() == systemFiles.getNeoForgeResources()) {
            throw new IllegalStateException("The Minecraft and NeoForge resources cannot come from the same jar: " + String.valueOf(systemFiles.getCommonResources()) + " and " + String.valueOf(systemFiles.getNeoForgeResources()));
        }
        ArrayList<JarContents.FilteredPath> mcJarRoots = new ArrayList<JarContents.FilteredPath>();
        mcJarRoots.addAll(GameLocator.getMinecraftResourcesRoots(context, systemFiles));
        JarContents.PathFilter mcClassesFilter = relativePath -> {
            if (relativePath.endsWith(".class")) {
                for (String pkg : NEOFORGE_SPECIFIC_PATH_PREFIXES) {
                    if (!relativePath.startsWith(pkg)) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
        GameLocator.addContentRoot(mcJarRoots, systemFiles.getCommonClasses(), mcClassesFilter);
        GameLocator.addContentRoot(mcJarRoots, systemFiles.getClientClasses(), mcClassesFilter);
        try {
            mcJarContents = JarContents.ofFilteredPaths(mcJarRoots);
        }
        catch (IOException e) {
            LOG.error("Failed to construct filtered Minecraft jar from {}", mcJarRoots);
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_minecraft_jar", new Object[0]).withCause(e));
        }
        return mcJarContents;
    }

    private static String detectMinecraftVersion(JarContents mcJarContents) {
        String minecraftVersion;
        try (InputStream in = mcJarContents.openFile("version.json");){
            if (in == null) {
                LOG.error("Minecraft version.json not found in {}.", (Object)mcJarContents);
                throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_minecraft_jar", new Object[0]));
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            JsonObject versionElement = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            JsonPrimitive idPrimitive = versionElement.getAsJsonPrimitive("id");
            if (idPrimitive == null) {
                LOG.error("Minecraft version.json found in {} is missing 'id' field. Available fields are: {}", (Object)mcJarContents, (Object)versionElement.keySet());
                throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_minecraft_jar", new Object[0]));
            }
            minecraftVersion = idPrimitive.getAsString();
        }
        catch (IOException e) {
            LOG.error("Failed to read Minecraft version.json from {}", (Object)mcJarContents);
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_minecraft_jar", new Object[0]).withCause(e));
        }
        return minecraftVersion;
    }

    private static List<JarContents.FilteredPath> getMinecraftResourcesRoots(ILaunchContext context, RequiredSystemFiles systemFiles) {
        JarContents commonResources = systemFiles.getCommonResources();
        JarContents clientResources = systemFiles.getClientResources();
        ArrayList<JarContents.FilteredPath> result = new ArrayList<JarContents.FilteredPath>();
        result.add(GameLocator.buildFilteredMinecraftResourcesFilteredPath(commonResources, context.getRequiredDistribution(), systemFiles));
        if (clientResources != null && clientResources != commonResources) {
            result.add(GameLocator.buildFilteredMinecraftResourcesFilteredPath(clientResources, context.getRequiredDistribution(), systemFiles));
        }
        return result;
    }

    private static JarContents.FilteredPath buildFilteredMinecraftResourcesFilteredPath(JarContents container, Dist requiredDist, RequiredSystemFiles systemFiles) {
        JarContents.PathFilter pathFilter = null;
        if (systemFiles.getClassesRoots().contains(container)) {
            pathFilter = relativePath -> !relativePath.endsWith(".class");
        }
        pathFilter = JarContents.PathFilter.and(pathFilter, GameLocator.getMaskedResourceFilter(container, requiredDist));
        return new JarContents.FilteredPath(container.getPrimaryPath(), pathFilter);
    }

    private static @Nullable JarContents.PathFilter getMaskedResourceFilter(JarContents jar, Dist requiredDist) {
        Set maskedResources = NeoForgeDevDistCleaner.getMaskedFiles(jar, requiredDist).filter(path -> !path.endsWith(".class")).collect(Collectors.toSet());
        if (!maskedResources.isEmpty()) {
            return relativePath -> {
                if (maskedResources.contains(relativePath)) {
                    LOG.debug("Masking access to {} since it's from a different Minecraft distribution.", (Object)relativePath);
                    return false;
                }
                return true;
            };
        }
        return null;
    }

    private static void addContentRoot(List<JarContents.FilteredPath> roots, JarContents jarContents, JarContents.PathFilter filter) {
        if (jarContents == null) {
            return;
        }
        for (JarContents.FilteredPath root : roots) {
            if (!root.path().equals(jarContents.getPrimaryPath()) || root.filter() != filter) continue;
            return;
        }
        roots.add(new JarContents.FilteredPath(jarContents.getPrimaryPath(), filter));
    }

    private static void locateProductionMinecraft(ILaunchContext context, IDiscoveryPipeline pipeline) {
        MavenCoordinate neoforgeCoordinate;
        Path neoforgeJar;
        String librariesDirectory = System.getProperty(LIBRARIES_DIRECTORY_PROPERTY);
        if (librariesDirectory == null) {
            LOG.error("When launching in production, the system property {} must point to the libraries directory.", (Object)LIBRARIES_DIRECTORY_PROPERTY);
            pipeline.addIssue(ModLoadingIssue.error("fml.modloadingissue.corrupted_installation", new Object[0]));
            return;
        }
        Path librariesRoot = Path.of(librariesDirectory, new String[0]);
        if (!Files.isDirectory(librariesRoot, new LinkOption[0])) {
            LOG.error("Libraries directory is not readable: {}", (Object)librariesRoot);
            pipeline.addIssue(ModLoadingIssue.error("fml.modloadingissue.corrupted_installation", new Object[0]));
            return;
        }
        PathPrettyPrinting.addSubstitution(librariesRoot, "~libraries/", "");
        VersionInfo versions = context.getVersions();
        String minecraftVersion = versions.mcVersion();
        if (minecraftVersion == null) {
            LOG.error("When launching in production, --fml.mcVersion must be present as a command-line argument");
            pipeline.addIssue(ModLoadingIssue.error("fml.modloadingissue.corrupted_installation", new Object[0]));
            return;
        }
        String neoForgeVersion = versions.neoForgeVersion();
        if (neoForgeVersion == null) {
            LOG.error("When launching in production, --fml.neoForgeVersion must be present as a command-line argument");
            pipeline.addIssue(ModLoadingIssue.error("fml.modloadingissue.corrupted_installation", new Object[0]));
            return;
        }
        String neoFormVersion = versions.neoFormVersion();
        if (neoFormVersion == null) {
            LOG.error("When launching in production, --fml.neoFormVersion must be present as a command-line argument");
            pipeline.addIssue(ModLoadingIssue.error("fml.modloadingissue.corrupted_installation", new Object[0]));
            return;
        }
        Path patchedMinecraftPath = librariesRoot.resolve((switch (context.getRequiredDistribution()) {
            default -> throw new MatchException(null, null);
            case Dist.CLIENT -> new MavenCoordinate("net.neoforged", "minecraft-client-patched", "", "", versions.neoForgeVersion());
            case Dist.DEDICATED_SERVER -> new MavenCoordinate("net.neoforged", "minecraft-server-patched", "", "", versions.neoForgeVersion());
        }).toRelativeRepositoryPath());
        if (Files.isRegularFile(patchedMinecraftPath, new LinkOption[0])) {
            if (pipeline.addPath(patchedMinecraftPath, ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.IGNORE).isEmpty()) {
                throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_minecraft_jar", new Object[0]).withAffectedPath(patchedMinecraftPath));
            }
        } else {
            ArrayList<Path> content = new ArrayList<Path>();
            switch (context.getRequiredDistribution()) {
                case CLIENT: {
                    GameLocator.addRequiredLibrary(new MavenCoordinate("net.minecraft", "client", "", "srg", versions.mcAndNeoFormVersion()), content);
                    GameLocator.addRequiredLibrary(new MavenCoordinate("net.minecraft", "client", "", "extra", versions.mcAndNeoFormVersion()), content);
                    GameLocator.addRequiredLibrary(new MavenCoordinate("net.neoforged", "neoforge", "", "client", versions.neoForgeVersion()), content);
                    break;
                }
                case DEDICATED_SERVER: {
                    GameLocator.addRequiredLibrary(new MavenCoordinate("net.minecraft", "server", "", "srg", versions.mcAndNeoFormVersion()), content);
                    GameLocator.addRequiredLibrary(new MavenCoordinate("net.minecraft", "server", "", "extra", versions.mcAndNeoFormVersion()), content);
                    GameLocator.addRequiredLibrary(new MavenCoordinate("net.neoforged", "neoforge", "", "server", versions.neoForgeVersion()), content);
                }
            }
            try {
                JarContents mcJarContents = JarContents.ofPaths(content);
                ModJarMetadata mcJarMetadata = new ModJarMetadata();
                IModFile mcjar = IModFile.create(mcJarContents, mcJarMetadata, new MinecraftModInfo(minecraftVersion)::buildMinecraftModInfo);
                mcJarMetadata.setModFile(mcjar);
                pipeline.addModFile(mcjar);
            }
            catch (Exception e) {
                pipeline.addIssue(ModLoadingIssue.error("fml.modloadingissue.corrupted_installation", new Object[0]).withCause(e));
            }
        }
        if (!Files.exists(neoforgeJar = librariesRoot.resolve((neoforgeCoordinate = new MavenCoordinate("net.neoforged", "neoforge", "", "universal", versions.neoForgeVersion())).toRelativeRepositoryPath()), new LinkOption[0])) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.missing_neoforge_jar", new Object[0]).withAffectedPath(neoforgeJar));
        }
        if (pipeline.addPath(neoforgeJar, ModFileDiscoveryAttributes.DEFAULT, IncompatibleFileReporting.IGNORE).isEmpty()) {
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_neoforge_jar", new Object[0]).withAffectedPath(neoforgeJar));
        }
    }

    private void preventLoadingOfObfuscatedClientJar(ILaunchContext context, ClassLoader ourCl) {
        try {
            Enumeration<URL> resources = ourCl.getResources("net/minecraft/DetectedVersion.class");
            while (resources.hasMoreElements()) {
                Path jarPath = ClasspathResourceUtils.findJarPathFor("net/minecraft/DetectedVersion.class", "minecraft jar", resources.nextElement());
                try (ZipFile zip = new ZipFile(jarPath.toFile());){
                    boolean hasClientResources;
                    boolean hasClientClasses;
                    if (zip.getEntry("data/.mcassetsroot") == null || (hasClientClasses = zip.getEntry("net/minecraft/client/Minecraft.class") != null) != (hasClientResources = zip.getEntry("assets/.mcassetsroot") != null) || zip.getEntry("META-INF/neoforge.mods.toml") != null) continue;
                    LOG.info("Marking unmodified client jar as claimed to prevent loading: {}", (Object)jarPath);
                    context.addLocated(jarPath);
                    return;
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addRequiredLibrary(MavenCoordinate coordinate, List<Path> content) {
        Path path = LibraryFinder.findPathForMaven(coordinate);
        if (!Files.exists(path, new LinkOption[0])) {
            LOG.error("Failed to find required file {}", (Object)path);
            throw new ModLoadingException(ModLoadingIssue.error("fml.modloadingissue.corrupted_installation", new Object[0]).withAffectedPath(path));
        }
        content.add(path);
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    public String toString() {
        return "game locator";
    }
}

