/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.neoforged.fml.jarcontents.JarResource;
import net.neoforged.fml.loading.LogMarkers;
import net.neoforged.fml.loading.moddiscovery.ModFile;
import net.neoforged.fml.loading.moddiscovery.ModFileInfo;
import net.neoforged.fml.loading.moddiscovery.NightConfigWrapper;
import net.neoforged.neoforgespi.language.IConfigurable;
import net.neoforged.neoforgespi.language.IModFileInfo;
import net.neoforged.neoforgespi.locating.IModFile;
import net.neoforged.neoforgespi.locating.InvalidModFileException;
import net.neoforged.neoforgespi.locating.ModFileInfoParser;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ModFileParser {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static IModFileInfo readModList(ModFile modFile, ModFileInfoParser parser) {
        return parser.build(modFile);
    }

    public static IModFileInfo modsTomlParser(IModFile imodFile) {
        UnmodifiableCommentedConfig config;
        ModFile modFile = (ModFile)imodFile;
        LOGGER.debug(LogMarkers.LOADING, "Considering mod file candidate {}", (Object)modFile.getFilePath());
        JarResource modsjson = modFile.getContents().get("META-INF/neoforge.mods.toml");
        if (modsjson == null) {
            LOGGER.warn(LogMarkers.LOADING, "Mod file {} is missing {} file", (Object)modFile.getFilePath(), (Object)"META-INF/neoforge.mods.toml");
            return null;
        }
        try (BufferedReader reader = modsjson.bufferedReader();){
            config = TomlFormat.instance().createParser().parse((Reader)reader).unmodifiable();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read " + String.valueOf(modsjson) + " from " + String.valueOf(imodFile), e);
        }
        NightConfigWrapper configWrapper = new NightConfigWrapper((UnmodifiableConfig)config);
        return new ModFileInfo(modFile, configWrapper, configWrapper::setFile);
    }

    protected static List<MixinConfig> getMixinConfigs(IModFileInfo modFileInfo) {
        try {
            IConfigurable config = modFileInfo.getConfig();
            List<? extends IConfigurable> mixinsEntries = config.getConfigList("mixins");
            ArrayList<MixinConfig> potentialMixins = new ArrayList<MixinConfig>();
            for (IConfigurable iConfigurable : mixinsEntries) {
                String name = (String)iConfigurable.getConfigElement("config").orElseThrow(() -> new InvalidModFileException("Missing \"config\" in [[mixins]] entry", modFileInfo));
                List<String> requiredModIds = iConfigurable.getConfigElement("requiredMods").orElse(List.of());
                DefaultArtifactVersion behaviorVersion = iConfigurable.getConfigElement("behaviorVersion").map(DefaultArtifactVersion::new).orElse(null);
                potentialMixins.add(new MixinConfig(name, requiredModIds, (ArtifactVersion)behaviorVersion));
            }
            return potentialMixins;
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load mixin configs from mod file", (Throwable)exception);
            return List.of();
        }
    }

    protected static Optional<List<String>> getAccessTransformers(IModFileInfo modFileInfo) {
        try {
            IConfigurable config = modFileInfo.getConfig();
            List<? extends IConfigurable> atEntries = config.getConfigList("accessTransformers");
            if (atEntries.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(atEntries.stream().map(entry -> (String)entry.getConfigElement("file").orElseThrow(() -> new InvalidModFileException("Missing \"file\" in [[accessTransformers]] entry", modFileInfo))).toList());
        }
        catch (Exception exception) {
            LOGGER.error("Failed to load access transformers from mod file", (Throwable)exception);
            return Optional.of(List.of());
        }
    }

    public record MixinConfig(String config, List<String> requiredMods, @Nullable ArtifactVersion behaviorVersion) {
    }
}

