/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.startup;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.startup.DevAgent;
import net.neoforged.fml.startup.FatalStartupException;
import net.neoforged.fml.startup.StartupArgs;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.status.StatusLogger;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Entrypoint {
    protected Entrypoint() {
    }

    protected static StartupResult startup(String[] args, boolean headless, Dist dist, boolean cleanDist) {
        long startupUptime = ManagementFactory.getRuntimeMXBean().getUptime();
        if (!Entrypoint.hasCustomLoggingConfiguration()) {
            Entrypoint.overwriteLoggingConfiguration();
        }
        Logger logger = LoggerFactory.getLogger(Entrypoint.class);
        logger.info("JVM Uptime at startup: {}ms", (Object)startupUptime);
        StartupArgs startupArgs = new StartupArgs(Entrypoint.getGameDir(args), headless, dist, cleanDist, args, new HashSet<File>(), Entrypoint.listClasspathEntries(), Thread.currentThread().getContextClassLoader());
        try {
            return new StartupResult(FMLLoader.create(DevAgent.getInstrumentation(), startupArgs), startupArgs);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            logger.error("Failed to start FML: {}", (Object)sw);
            throw new FatalStartupException("Failed to start FML: " + String.valueOf(e), startupArgs, e);
        }
    }

    private static List<File> listClasspathEntries() {
        String[] classPathEntries = System.getProperty("java.class.path").split(File.pathSeparator);
        ArrayList<File> result = new ArrayList<File>(classPathEntries.length);
        for (String classPathEntry : classPathEntries) {
            File file = new File(classPathEntry);
            result.add(file);
        }
        return result;
    }

    private static Path getGameDir(String[] args) {
        File gameDir = new File(Entrypoint.getArg(args, "gameDir", "")).getAbsoluteFile();
        if (!gameDir.isDirectory()) {
            throw new RuntimeException("The game directory passed on the command-line is not a directory: " + String.valueOf(gameDir));
        }
        return gameDir.toPath();
    }

    private static String getArg(String[] args, String name, String defaultValue) {
        String argName = "--" + name;
        int i = 0;
        while (i + 1 < args.length) {
            if (argName.equals(args[i])) {
                return args[i + 1];
            }
            ++i;
        }
        return defaultValue;
    }

    private static boolean hasCustomLoggingConfiguration() {
        return System.getProperty("log4j2.configurationFile") != null || System.getProperty("log4j.configurationFile") != null || System.getenv("LOG4J_CONFIGURATION_FILE") != null;
    }

    static void overwriteLoggingConfiguration() {
        URL loggingConfigUrl;
        if (System.getProperty("log4j2.disable.jmx") == null && System.getenv("LOG4J_DISABLE_JMX") == null) {
            System.setProperty("log4j2.disable.jmx", "true");
        }
        if ((loggingConfigUrl = Entrypoint.class.getResource("log4j2.xml")) != null) {
            URI loggingConfigUri;
            try {
                loggingConfigUri = loggingConfigUrl.toURI();
            }
            catch (URISyntaxException e) {
                StatusLogger.getLogger().error("Failed to read FML logging configuration: {}", (Object)loggingConfigUrl, (Object)e);
                return;
            }
            ConfigurationSource configSource = ConfigurationSource.fromUri((URI)loggingConfigUri);
            Configurator.reconfigure((Configuration)ConfigurationFactory.getInstance().getConfiguration(LoggerContext.getContext(), configSource));
            StatusLogger.getLogger().debug("Reconfiguring logging with configuration from {}", (Object)loggingConfigUri);
        }
    }

    protected static MethodHandle createMainMethodCallable(StartupResult startupResult, String mainClassName) {
        try {
            ClassLoader currentClassLoader = startupResult.loader.getCurrentClassLoader();
            Class<?> mainClass = Class.forName(mainClassName, true, currentClassLoader);
            if (mainClass.getClassLoader() != currentClassLoader) {
                throw new FatalStartupException("Missing main class " + mainClassName + " from the game content loader (but available on " + String.valueOf(mainClass.getClassLoader()) + ").", startupResult.startupArgs);
            }
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodType methodType = MethodType.methodType(Void.TYPE, String[].class);
            return lookup.findStatic(mainClass, "main", methodType);
        }
        catch (ClassNotFoundException e) {
            throw new FatalStartupException("Missing main class " + mainClassName + " on the classpath.", startupResult.startupArgs);
        }
        catch (NoSuchMethodException e) {
            throw new FatalStartupException(mainClassName + " is missing a static 'main' method.", startupResult.startupArgs);
        }
        catch (Throwable e) {
            throw new FatalStartupException("Failed to create entrypoint object.", startupResult.startupArgs, e);
        }
    }

    @Nullable
    protected static Thread findThread(String threadName) {
        Thread serverThread = null;
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (!threadName.equals(thread.getName()) || serverThread != null && thread.threadId() > serverThread.threadId()) continue;
            serverThread = thread;
        }
        return serverThread;
    }

    protected record StartupResult(FMLLoader loader, StartupArgs startupArgs) implements AutoCloseable
    {
        @Override
        public void close() throws Exception {
            this.loader.close();
        }
    }
}

