/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiPredicate;
import net.neoforged.fml.loading.VersionInfo;
import net.neoforged.neoforgespi.language.MavenVersionAdapter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;

class VersionSupportMatrix {
    private static final HashMap<String, List<ArtifactVersion>> overrideVersions = new HashMap();

    public VersionSupportMatrix(VersionInfo versionInfo) {
        DefaultArtifactVersion mcVersion = new DefaultArtifactVersion(versionInfo.mcVersion());
        if (MavenVersionAdapter.createFromVersionSpec("[1.21.8]").containsVersion((ArtifactVersion)mcVersion)) {
            this.add("mod.minecraft", "1.21.7");
            this.add("mod.neoforge", "21.7.26-beta");
        }
    }

    private void add(String key, String value) {
        overrideVersions.computeIfAbsent(key, k -> new ArrayList()).add(new DefaultArtifactVersion(value));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testVersionSupportMatrix(VersionRange declaredRange, String lookupId, String type, BiPredicate<String, VersionRange> standardLookup) {
        if (standardLookup.test(lookupId, declaredRange)) {
            return true;
        }
        List<ArtifactVersion> custom = overrideVersions.get(type + "." + lookupId);
        if (custom == null) return false;
        if (!custom.stream().anyMatch(arg_0 -> ((VersionRange)declaredRange).containsVersion(arg_0))) return false;
        return true;
    }
}

