/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.jarmoduleinfo;

import java.lang.module.ModuleDescriptor;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarmoduleinfo.JarModuleInfo;
import net.neoforged.fml.jarmoduleinfo.ModuleDescriptorFactory;
import net.neoforged.fml.jarmoduleinfo.NameAndVersion;
import org.jetbrains.annotations.Nullable;

class AuomaticModuleJarModuleInfo
implements JarModuleInfo {
    private final String name;
    private final String version;

    private AuomaticModuleJarModuleInfo(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public static AuomaticModuleJarModuleInfo from(JarContents contents) {
        NameAndVersion nav = ModuleDescriptorFactory.computeNameAndVersion(contents.getPrimaryPath());
        String name = nav.name();
        String version = nav.version();
        String automaticModuleName = contents.getManifest().getMainAttributes().getValue("Automatic-Module-Name");
        if (automaticModuleName != null) {
            name = automaticModuleName;
        }
        return new AuomaticModuleJarModuleInfo(name, version);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @Nullable
    public String version() {
        return this.version;
    }

    @Override
    public ModuleDescriptor createDescriptor(JarContents contents) {
        ModuleDescriptor.Builder bld = ModuleDescriptor.newAutomaticModule(this.name());
        if (this.version() != null) {
            bld.version(this.version());
        }
        ModuleDescriptorFactory.scanAutomaticModule(contents, bld, new String[0]);
        return bld.build();
    }
}

