/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.startup;

import java.lang.invoke.MethodHandle;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.startup.Entrypoint;
import net.neoforged.fml.startup.FatalErrorReporting;
import net.neoforged.fml.startup.FatalStartupException;

public class GameTestServer
extends Entrypoint {
    private GameTestServer() {
    }

    public static void main(String[] args) {
        try (Entrypoint.StartupResult startupResult = GameTestServer.startup(args, true, Dist.DEDICATED_SERVER, false);){
            MethodHandle main = GameTestServer.createMainMethodCallable(startupResult, "net.minecraft.gametest.Main");
            main.invokeExact(startupResult.loader().getProgramArgs().getArguments());
            Thread serverThread = GameTestServer.findThread("Server thread");
            if (serverThread == null) {
                throw new FatalStartupException("Couldn't find Minecraft server thread. Startup likely failed.", startupResult.startupArgs());
            }
            serverThread.join();
        }
        catch (Throwable t) {
            FatalErrorReporting.reportFatalErrorOnConsole(t);
            System.exit(1);
        }
    }
}

