/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.jarcontents;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import net.neoforged.fml.jarcontents.EmptyManifest;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarcontents.JarResource;
import net.neoforged.fml.jarcontents.JarResourceAttributes;
import net.neoforged.fml.jarcontents.JarResourceVisitor;
import net.neoforged.fml.jarcontents.PathNormalization;
import net.neoforged.fml.util.PathPrettyPrinting;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class FolderJarContents
implements JarContents {
    private final Path path;
    private final Object manifestLock = new Object();
    private Manifest cachedManifest;

    public FolderJarContents(Path path) {
        this.path = path;
    }

    @Override
    public Path getPrimaryPath() {
        return this.path;
    }

    @Override
    public Optional<String> getChecksum() {
        return Optional.empty();
    }

    @Override
    @Nullable
    public JarResource get(String relativePath) {
        Path path = this.fromRelativePath(relativePath);
        if (Files.isRegularFile(path, new LinkOption[0])) {
            return new FileResource(path, false);
        }
        return null;
    }

    @Override
    public boolean containsFile(String relativePath) {
        return Files.isRegularFile(this.fromRelativePath(relativePath), new LinkOption[0]);
    }

    @Override
    public InputStream openFile(String relativePath) throws IOException {
        try {
            return Files.newInputStream(this.fromRelativePath(relativePath), new OpenOption[0]);
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    @Override
    public byte[] readFile(String relativePath) throws IOException {
        try {
            return Files.readAllBytes(this.fromRelativePath(relativePath));
        }
        catch (NoSuchFileException e) {
            return null;
        }
    }

    @Override
    public Collection<Path> getContentRoots() {
        return List.of(this.path);
    }

    @Override
    public void visitContent(String startingFolder, JarResourceVisitor visitor) {
        Path startingPoint = this.getVisitStartingPoint(startingFolder);
        if (!startingPoint.startsWith(this.path)) {
            return;
        }
        if (!Files.isDirectory(startingPoint, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream2 = Files.walk(startingPoint, new FileVisitOption[0]);){
            FileResource locatedResource = new FileResource(null, true);
            stream2.forEach(path -> {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    String relativePath = PathNormalization.normalize(this.path.relativize((Path)path).toString());
                    locatedResource.path = path;
                    visitor.visit(relativePath, locatedResource);
                }
            });
        }
        catch (NoSuchFileException stream2) {
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to walk contents of " + String.valueOf(this), e);
        }
    }

    private Path getVisitStartingPoint(String startingFolder) {
        startingFolder = PathNormalization.normalize(startingFolder);
        Path startingPoint = this.path;
        if (!startingFolder.isEmpty()) {
            startingPoint = this.path.resolve(startingFolder).normalize();
        }
        return startingPoint;
    }

    @Override
    public Optional<URI> findFile(String relativePath) {
        Path pathToFile = this.fromRelativePath(relativePath);
        return Files.isRegularFile(pathToFile, new LinkOption[0]) ? Optional.of(pathToFile.toUri()) : Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() {
        Manifest manifest = this.cachedManifest;
        if (manifest == null) {
            Object object = this.manifestLock;
            synchronized (object) {
                manifest = this.cachedManifest;
                if (manifest == null) {
                    Path manifestFile = this.path.resolve("META-INF/MANIFEST.MF");
                    try (InputStream in = Files.newInputStream(manifestFile, new OpenOption[0]);){
                        manifest = new Manifest(in);
                    }
                    catch (NoSuchFileException ignored) {
                        manifest = EmptyManifest.INSTANCE;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("Failed to read manifest " + String.valueOf(manifestFile), e);
                    }
                    this.cachedManifest = manifest;
                }
            }
        }
        return manifest;
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "folder(" + PathPrettyPrinting.prettyPrint(this.path) + ")";
    }

    private Path fromRelativePath(String relativePath) {
        relativePath = PathNormalization.normalize(relativePath);
        return this.path.resolve(relativePath);
    }

    private static class FileResource
    implements JarResource {
        private final boolean mutable;
        private Path path;

        public FileResource(Path path, boolean mutable) {
            this.path = path;
            this.mutable = mutable;
        }

        @Override
        public InputStream open() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }

        @Override
        public JarResourceAttributes attributes() throws IOException {
            BasicFileAttributes attributes = Files.getFileAttributeView(this.path, BasicFileAttributeView.class, new LinkOption[0]).readAttributes();
            return new JarResourceAttributes(attributes.lastModifiedTime(), attributes.size());
        }

        @Override
        public JarResource retain() {
            if (this.mutable) {
                return new FileResource(this.path, false);
            }
            return this;
        }
    }
}

