/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.common.asm.enumextension;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.lang.model.SourceVersion;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.ModLoadingIssue;
import net.neoforged.fml.common.asm.enumextension.EnumParameters;
import net.neoforged.fml.jarcontents.JarResource;
import net.neoforged.neoforgespi.language.IModInfo;
import org.objectweb.asm.Type;

record EnumPrototype(String owningMod, String enumName, String fieldName, String ctorDesc, String fullCtorDesc, EnumParameters ctorParams) implements Comparable<EnumPrototype>
{
    private static final String ENUM_CTOR_BASE_DESC = "Ljava/lang/String;I";
    private static final Gson GSON = new Gson();

    @Override
    public int compareTo(EnumPrototype other) {
        int comp = this.owningMod.compareTo(other.owningMod);
        return comp != 0 ? comp : this.fieldName.compareTo(other.fieldName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static List<EnumPrototype> load(IModInfo mod, JarResource resource) {
        try (BufferedReader reader = resource.bufferedReader();){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            JsonArray entries = json.getAsJsonArray("entries");
            ArrayList<EnumPrototype> prototypes = new ArrayList<EnumPrototype>(entries.size());
            for (JsonElement entry : entries) {
                EnumParameters ctorParams;
                String ctorDesc;
                String fieldName;
                String enumName;
                block21: {
                    JsonElement paramElem;
                    block23: {
                        block22: {
                            JsonObject entryObj = entry.getAsJsonObject();
                            enumName = entryObj.get("enum").getAsString();
                            if (!EnumPrototype.isValidClassDescriptor(enumName)) {
                                EnumPrototype.error("fml.modloadingissue.enumextender.invalid_enum_name", mod, enumName);
                                continue;
                            }
                            fieldName = entryObj.get("name").getAsString();
                            if (!fieldName.toLowerCase(Locale.ROOT).startsWith(mod.getModId())) {
                                EnumPrototype.error("fml.modloadingissue.enumextender.field_name.missing_prefix", mod, fieldName, enumName);
                                continue;
                            }
                            if (!SourceVersion.isIdentifier(fieldName)) {
                                EnumPrototype.error("fml.modloadingissue.enumextender.field_name.invalid", mod, fieldName, enumName);
                                continue;
                            }
                            ctorDesc = entryObj.get("constructor").getAsString();
                            if (!EnumPrototype.isValidConstructorDescriptor(ctorDesc)) {
                                EnumPrototype.error("fml.modloadingissue.enumextender.invalid_constructor", mod, ctorDesc, enumName);
                                continue;
                            }
                            paramElem = entryObj.get("parameters");
                            if (!paramElem.isJsonArray()) break block22;
                            ctorParams = EnumPrototype.loadConstantParameters(mod, enumName, fieldName, ctorDesc, paramElem.getAsJsonArray());
                            if (ctorParams == null) {
                                continue;
                            }
                            break block21;
                        }
                        if (!paramElem.isJsonObject()) break block23;
                        JsonObject obj = paramElem.getAsJsonObject();
                        String className = obj.get("class").getAsString();
                        if (!EnumPrototype.isValidClassDescriptor(className)) {
                            EnumPrototype.error("fml.modloadingissue.enumextender.argument.reference.invalid_src_class", mod, className, fieldName, enumName);
                            continue;
                        }
                        if (obj.has("method")) {
                            String srcMethodName = obj.get("method").getAsString();
                            if (!SourceVersion.isIdentifier(srcMethodName)) {
                                EnumPrototype.error("fml.modloadingissue.enumextender.argument.reference.invalid_src_method", mod, srcMethodName, fieldName, enumName);
                                continue;
                            }
                            ctorParams = new EnumParameters.MethodReference(Type.getObjectType((String)className), srcMethodName);
                            break block21;
                        } else if (obj.has("field")) {
                            String srcFieldName = obj.get("field").getAsString();
                            if (!SourceVersion.isIdentifier(srcFieldName)) {
                                EnumPrototype.error("fml.modloadingissue.enumextender.argument.reference.invalid_src_field", mod, srcFieldName, fieldName, enumName);
                                continue;
                            }
                            ctorParams = new EnumParameters.FieldReference(Type.getObjectType((String)className), srcFieldName);
                            break block21;
                        } else {
                            EnumPrototype.error("fml.modloadingissue.enumextender.argument.reference.unexpected_decl", mod, paramElem, fieldName, enumName);
                            continue;
                        }
                    }
                    EnumPrototype.error("fml.modloadingissue.enumextender.argument.unexpected_decl", mod, paramElem, fieldName, enumName);
                    continue;
                }
                String fullCtorDesc = "(Ljava/lang/String;I" + ctorDesc.substring(1);
                prototypes.add(new EnumPrototype(mod.getModId(), enumName, fieldName, ctorDesc, fullCtorDesc, ctorParams));
            }
            ArrayList<EnumPrototype> arrayList = prototypes;
            return arrayList;
        }
        catch (Throwable e) {
            ModLoader.addLoadingIssue(ModLoadingIssue.error("fml.modloadingissue.enumextender.loading_error", resource).withAffectedMod(mod).withCause(e));
            return List.of();
        }
    }

    private static EnumParameters loadConstantParameters(IModInfo mod, String enumName, String fieldName, String ctorDesc, JsonArray obj) {
        ArrayList<Object> params = new ArrayList<Object>(obj.size());
        Type[] argTypes = Type.getArgumentTypes((String)ctorDesc);
        if (argTypes.length != obj.size()) {
            EnumPrototype.error("fml.modloadingissue.enumextender.argument.constant.count_mismatch", mod, obj.size(), argTypes.length, ctorDesc, fieldName, enumName);
            return null;
        }
        int idx = 0;
        for (JsonElement element : obj) {
            Type argType = argTypes[idx];
            switch (argType.getDescriptor()) {
                case "Z": {
                    params.add(element.getAsBoolean());
                    break;
                }
                case "C": {
                    String param = element.getAsString();
                    if (param.length() != 1) {
                        EnumPrototype.error("fml.modloadingissue.enumextender.argument.constant.invalid_char", mod, param, idx, fieldName, enumName);
                        return null;
                    }
                    params.add(Character.valueOf(param.charAt(0)));
                    break;
                }
                case "B": {
                    params.add(element.getAsByte());
                    break;
                }
                case "S": {
                    params.add(element.getAsShort());
                    break;
                }
                case "I": {
                    params.add(element.getAsInt());
                    break;
                }
                case "F": {
                    params.add(Float.valueOf(element.getAsFloat()));
                    break;
                }
                case "J": {
                    params.add(element.getAsLong());
                    break;
                }
                case "D": {
                    params.add(element.getAsDouble());
                    break;
                }
                case "Ljava/lang/String;": {
                    params.add(element.isJsonNull() ? null : element.getAsString());
                    break;
                }
                default: {
                    if (!element.isJsonNull()) {
                        EnumPrototype.error("fml.modloadingissue.enumextender.argument.constant.unsupported_type", mod, argType, idx, fieldName, enumName);
                        return null;
                    }
                    params.add(null);
                }
            }
            ++idx;
        }
        return new EnumParameters.Constant(params);
    }

    private static boolean isValidClassDescriptor(String desc) {
        for (String part : desc.split("/", -1)) {
            if (SourceVersion.isIdentifier(part)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidConstructorDescriptor(String desc) {
        if (!desc.startsWith("(")) {
            return false;
        }
        if (!desc.endsWith(")V")) {
            return false;
        }
        boolean pendingArray = false;
        for (int i = 1; i < desc.length() - 2; ++i) {
            char c = desc.charAt(i);
            if ("ZCBSIFJD".indexOf(c) != -1) {
                pendingArray = false;
                continue;
            }
            if (c == '[') {
                pendingArray = true;
                continue;
            }
            if (c != 'L') {
                return false;
            }
            int semicolon = desc.indexOf(59, i);
            if (semicolon <= i) {
                return false;
            }
            String segment = desc.substring(i + 1, semicolon);
            if (!EnumPrototype.isValidClassDescriptor(segment)) {
                return false;
            }
            i = semicolon;
            pendingArray = false;
        }
        return !pendingArray;
    }

    private static void error(String message, IModInfo mod, Object ... params) {
        ModLoader.addLoadingIssue(ModLoadingIssue.error(message, params).withAffectedMod(mod));
    }
}

