/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforgespi.transformation;

import java.util.SequencedMap;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.neoforged.neoforgespi.transformation.BytecodeProvider;
import net.neoforged.neoforgespi.transformation.ClassProcessorIds;
import net.neoforged.neoforgespi.transformation.ProcessorName;
import net.neoforged.neoforgespi.transformation.SimpleTransformationContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Unmodifiable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;

public interface ClassProcessor {
    public static final String GENERATED_PACKAGE_MODULE = "net.neoforged.fml.generated";

    public ProcessorName name();

    default public Set<ProcessorName> runsBefore() {
        return Set.of();
    }

    default public Set<ProcessorName> runsAfter() {
        return Set.of(ClassProcessorIds.COMPUTING_FRAMES);
    }

    default public Set<String> generatesPackages() {
        return Set.of();
    }

    default public OrderingHint orderingHint() {
        return OrderingHint.DEFAULT;
    }

    public boolean handlesClass(SelectionContext var1);

    public ComputeFlags processClass(TransformationContext var1);

    default public void afterProcessing(AfterProcessingContext context) {
    }

    default public void link(LinkContext context) {
    }

    public static enum OrderingHint {
        EARLY,
        DEFAULT,
        LATE;

    }

    public record LinkContext(@Unmodifiable SequencedMap<ProcessorName, ClassProcessor> processors, BytecodeProvider bytecodeProvider) {
    }

    public record AfterProcessingContext(Type type) {
    }

    public static final class TransformationContext
    implements SimpleTransformationContext {
        private final Type type;
        private final ClassNode node;
        private final boolean empty;
        private final BiConsumer<String, String[]> auditTrail;
        private final Supplier<byte[]> initialSha256;

        @ApiStatus.Internal
        public TransformationContext(Type type, ClassNode node, boolean empty, BiConsumer<String, String[]> auditTrail, Supplier<byte[]> initialSha256) {
            this.type = type;
            this.node = node;
            this.empty = empty;
            this.auditTrail = auditTrail;
            this.initialSha256 = initialSha256;
        }

        @Override
        public Type type() {
            return this.type;
        }

        public ClassNode node() {
            return this.node;
        }

        @Override
        public boolean empty() {
            return this.empty;
        }

        public void audit(String activity, String ... context) {
            this.auditTrail.accept(activity, context);
        }

        @Override
        public byte[] initialSha256() {
            return this.initialSha256.get();
        }
    }

    public record SelectionContext(Type type, boolean empty) {
    }

    public static enum ComputeFlags {
        NO_REWRITE,
        SIMPLE_REWRITE,
        COMPUTE_MAXS,
        COMPUTE_FRAMES;


        public ComputeFlags max(ComputeFlags other) {
            return this.ordinal() > other.ordinal() ? this : other;
        }
    }
}

