/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.jarcontents;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import net.neoforged.fml.jarcontents.EmptyManifest;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarcontents.JarResource;
import net.neoforged.fml.jarcontents.JarResourceAttributes;
import net.neoforged.fml.jarcontents.JarResourceVisitor;
import net.neoforged.fml.jarcontents.PathNormalization;
import net.neoforged.fml.util.PathPrettyPrinting;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JarFileContents
implements JarContents {
    private final Path path;
    private final JarFile jarFile;
    private final Manifest jarManifest;

    public JarFileContents(Path path) throws IOException {
        this.path = path;
        this.jarFile = new JarFile(path.toFile(), true, 1, JarFile.runtimeVersion());
        this.jarManifest = Objects.requireNonNullElse(this.jarFile.getManifest(), EmptyManifest.INSTANCE);
    }

    @Override
    public Path getPrimaryPath() {
        return this.path;
    }

    @Override
    public Collection<Path> getContentRoots() {
        return List.of(this.path);
    }

    @Override
    public Optional<String> getChecksum() {
        Optional<String> optional;
        block9: {
            InputStream in = Files.newInputStream(this.path, new OpenOption[0]);
            try {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                DigestInputStream digestIn = new DigestInputStream(in, digest);
                digestIn.transferTo(OutputStream.nullOutputStream());
                optional = Optional.of(HexFormat.of().formatHex(digest.digest()));
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to compute checksum for " + String.valueOf(this.path), e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Standard JCA algorithm is missing.", e);
                }
            }
            in.close();
        }
        return optional;
    }

    public String toString() {
        return "jar(" + PathPrettyPrinting.prettyPrint(this.path) + ")";
    }

    @Override
    @Nullable
    public Manifest getManifest() {
        return this.jarManifest;
    }

    @Override
    public Optional<URI> findFile(String relativePath) {
        ZipEntry entry = this.jarFile.getEntry(relativePath = PathNormalization.normalize(relativePath));
        if (entry != null && !entry.isDirectory()) {
            return Optional.of(URI.create("jar:" + String.valueOf(this.path.toUri()) + "!/" + relativePath));
        }
        return Optional.empty();
    }

    @Override
    public JarResource get(String relativePath) {
        JarEntry entry = this.jarFile.getJarEntry(relativePath = PathNormalization.normalize(relativePath));
        if (entry == null || entry.isDirectory()) {
            return null;
        }
        return new JarEntryResource(entry, false);
    }

    @Override
    public boolean containsFile(String relativePath) {
        ZipEntry entry = this.jarFile.getEntry(relativePath = PathNormalization.normalize(relativePath));
        return entry != null && !entry.isDirectory();
    }

    @Override
    public InputStream openFile(String relativePath) throws IOException {
        if ((relativePath = PathNormalization.normalize(relativePath)).isEmpty()) {
            throw new IOException("The path refers to the root directory");
        }
        ZipEntry entry = this.jarFile.getEntry(relativePath);
        if (entry != null) {
            if (entry.isDirectory()) {
                throw new IOException("The path " + relativePath + " refers to a directory");
            }
            return this.jarFile.getInputStream(entry);
        }
        return null;
    }

    @Override
    public byte[] readFile(String relativePath) throws IOException {
        if ((relativePath = PathNormalization.normalize(relativePath)).isEmpty()) {
            throw new IOException("The path refers to the root directory");
        }
        ZipEntry entry = this.jarFile.getEntry(relativePath);
        if (entry != null) {
            if (entry.isDirectory()) {
                throw new IOException("The path " + relativePath + " refers to a directory");
            }
            try (InputStream input = this.jarFile.getInputStream(entry);){
                byte[] byArray = input.readAllBytes();
                return byArray;
            }
        }
        return null;
    }

    @Override
    public void visitContent(String startingFolder, JarResourceVisitor visitor) {
        startingFolder = PathNormalization.normalizeFolderPrefix(startingFolder);
        JarEntryResource resource = new JarEntryResource(null, true);
        Iterator<JarEntry> it = this.jarFile.entries().asIterator();
        while (it.hasNext()) {
            JarEntry entry = it.next();
            if (entry.isDirectory() || !startingFolder.isEmpty() && !entry.getName().startsWith(startingFolder)) continue;
            String relativePath = PathNormalization.normalize(entry.getName());
            resource.entry = entry;
            visitor.visit(relativePath, resource);
        }
    }

    @Override
    public void close() {
        try {
            this.jarFile.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close ZIP-File " + String.valueOf(this.path), e);
        }
    }

    private final class JarEntryResource
    implements JarResource {
        private final boolean mutable;
        private JarEntry entry;

        public JarEntryResource(JarEntry entry, boolean mutable) {
            this.entry = entry;
            this.mutable = mutable;
        }

        @Override
        public InputStream open() throws IOException {
            return JarFileContents.this.jarFile.getInputStream(this.entry);
        }

        @Override
        public JarResourceAttributes attributes() {
            return new JarResourceAttributes(this.entry.getLastModifiedTime(), this.entry.getSize());
        }

        @Override
        public JarResource retain() {
            if (this.mutable) {
                return new JarEntryResource(this.entry, false);
            }
            return this;
        }
    }
}

