/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.jarcontents;

import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Manifest;
import net.neoforged.fml.jarcontents.EmptyManifest;
import net.neoforged.fml.jarcontents.JarContents;
import net.neoforged.fml.jarcontents.JarResource;
import net.neoforged.fml.jarcontents.JarResourceVisitor;
import net.neoforged.fml.util.PathPrettyPrinting;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class EmptyJarContents
implements JarContents {
    private final Path path;

    public EmptyJarContents(Path path) {
        this.path = Objects.requireNonNull(path, "path");
    }

    @Override
    public Optional<String> getChecksum() {
        return Optional.empty();
    }

    @Override
    public Optional<URI> findFile(String relativePath) {
        return Optional.empty();
    }

    @Override
    @Nullable
    public JarResource get(String relativePath) {
        return null;
    }

    @Override
    public boolean containsFile(String relativePath) {
        return false;
    }

    @Override
    public Path getPrimaryPath() {
        return this.path;
    }

    @Override
    public Collection<Path> getContentRoots() {
        return List.of();
    }

    @Override
    public Manifest getManifest() {
        return EmptyManifest.INSTANCE;
    }

    @Override
    @Nullable
    public InputStream openFile(String relativePath) {
        return null;
    }

    @Override
    public byte @Nullable [] readFile(String relativePath) {
        return null;
    }

    @Override
    public void visitContent(String startingFolder, JarResourceVisitor visitor) {
    }

    @Override
    public void close() {
    }

    public String toString() {
        return "empty(" + PathPrettyPrinting.prettyPrint(this.path) + ")";
    }
}

